/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.framework.internal.tooling.type.propagation.utils.CoreUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;

class LocationHierarchyVerifier {
    private final Map<ComponentLocation, Set<ComponentLocation>> parentOf = new HashMap<ComponentLocation, Set<ComponentLocation>>();

    public LocationHierarchyVerifier(ArtifactAst application, Function<ComponentLocation, Boolean> isWithinAnalyzed) {
        this.generateHierarchy(application, isWithinAnalyzed);
    }

    private void generateHierarchy(ArtifactAst application, Function<ComponentLocation, Boolean> isWithinAnalyzed) {
        HashMap flowRefs = new HashMap();
        MuleAstUtils.recursiveStreamWithHierarchy((ArtifactAst)application).filter(pair -> (Boolean)isWithinAnalyzed.apply(((ComponentAst)pair.getFirst()).getLocation())).forEach(pair -> {
            HashSet childOf = new HashSet();
            ((List)pair.getSecond()).stream().filter(CoreUtils::isCoreCollectionBasedScopeOrRouter).map(ComponentAst::getLocation).forEach(childOf::add);
            this.parentOf.put(((ComponentAst)pair.getFirst()).getLocation(), childOf);
            if (CoreUtils.isFlowRef((ComponentAst)pair.getFirst())) {
                CoreUtils.retrieveFlowRefName((ComponentAst)pair.getFirst()).ifPresent(flowName -> {
                    if (!flowRefs.containsKey(flowName)) {
                        flowRefs.put(flowName, new ArrayList());
                    }
                    ((List)flowRefs.get(flowName)).add(((ComponentAst)pair.getFirst()).getLocation());
                });
            }
        });
        application.topLevelComponentsStream().filter(componentAst -> flowRefs.containsKey(componentAst.getLocation().getRootContainerName())).forEach(componentAst -> componentAst.recursiveStream().forEach(elementFromReferencedFlow -> this.setAllParentsOfFlowRefAsParentOfAllComponentsOfFlow(flowRefs, (ComponentAst)elementFromReferencedFlow)));
    }

    public boolean isChildElement(ComponentLocation allegedParent, ComponentLocation allegedChild) {
        return this.parentOf.containsKey(allegedChild) && this.parentOf.get(allegedChild).contains(allegedParent);
    }

    public boolean allUpToCommonSibling(ComponentLocation previous, ComponentLocation current, Predicate<ComponentLocation> predicate) {
        if (!this.parentOf.containsKey(previous) || !this.parentOf.containsKey(current)) {
            return true;
        }
        ArrayList<ComponentLocation> toCheck = new ArrayList<ComponentLocation>();
        for (ComponentLocation parent : this.parentOf.get(previous)) {
            if (this.parentOf.get(current).contains(parent)) continue;
            toCheck.add(parent);
        }
        return toCheck.stream().allMatch(predicate);
    }

    private void setAllParentsOfFlowRefAsParentOf(ComponentLocation flowRefLocation, ComponentLocation childFromAnotherFlow) {
        if (this.parentOf.containsKey(flowRefLocation)) {
            if (!this.parentOf.containsKey(childFromAnotherFlow)) {
                this.parentOf.put(childFromAnotherFlow, new HashSet());
            }
            this.parentOf.get(childFromAnotherFlow).addAll((Collection<ComponentLocation>)this.parentOf.get(flowRefLocation));
        }
    }

    private void setAllParentsOfFlowRefAsParentOfAllComponentsOfFlow(Map<String, List<ComponentLocation>> flowRefs, ComponentAst elementFromReferencedFlow) {
        this.getAllFlowRefLocationsToThisComponentsFlow(flowRefs, elementFromReferencedFlow).forEach(flowRefLocation -> this.setAllParentsOfFlowRefAsParentOf((ComponentLocation)flowRefLocation, elementFromReferencedFlow.getLocation()));
    }

    private List<ComponentLocation> getAllFlowRefLocationsToThisComponentsFlow(Map<String, List<ComponentLocation>> flowRefs, ComponentAst ast) {
        return flowRefs.get(ast.getLocation().getRootContainerName());
    }
}

