/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation;

import com.mulesoft.mule.framework.api.tooling.type.bindings.ComponentConditions;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypePropagationResult;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypedChainComponent;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypedEventField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.framework.internal.tooling.type.propagation.LocationHierarchyVerifier;
import org.mule.framework.internal.tooling.type.propagation.utils.ConditionsBuilder;
import org.mule.framework.internal.tooling.type.propagation.utils.CoreUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.DefaultBindingCondition;
import org.mule.framework.internal.tooling.type.propagation.utils.ExpressionUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public final class DefaultTypePropagationResult
implements TypePropagationResult {
    private static final MetadataType ANY_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).anyType().build();
    private final boolean success;
    private final ComponentLocation mainFlow;
    private final Map<ComponentLocation, TypedChainComponent> info;
    private final Map<ComponentLocation, ComponentAst> toAst = new LinkedHashMap<ComponentLocation, ComponentAst>();
    private final List<I18nMessage> failures;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final LocationHierarchyVerifier hierarchyVerifier;
    private final LazyValue<Map<ComponentLocation, ComponentConditions>> cmpConditions;
    private final Set<ComponentLocation> interruptedChains;

    private DefaultTypePropagationResult(boolean success, ArtifactAst application, ComponentLocation mainFlow, Map<ComponentLocation, TypedChainComponent> info, Set<ComponentLocation> interruptedChains, List<I18nMessage> failures, Optional<MuleEventMetadataType> apikitOutput, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.success = success;
        this.info = info;
        application.recursiveStream().filter(componentAst -> info.containsKey(componentAst.getLocation())).forEach(componentAst -> this.toAst.put(componentAst.getLocation(), (ComponentAst)componentAst));
        this.failures = failures;
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.hierarchyVerifier = new LocationHierarchyVerifier(application, info::containsKey);
        this.cmpConditions = new LazyValue(() -> this.lazyRetrieveConditions(apikitOutput));
        this.mainFlow = mainFlow;
        this.interruptedChains = interruptedChains;
    }

    public static DefaultTypePropagationResult success(ArtifactAst application, ComponentLocation mainFlow, Map<ComponentLocation, TypedChainComponent> info, Set<ComponentLocation> interruptedChains, Optional<MuleEventMetadataType> apikitOutput, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        return new DefaultTypePropagationResult(true, application, mainFlow, info, interruptedChains, Collections.emptyList(), apikitOutput, expressionLanguageMetadataService);
    }

    public static DefaultTypePropagationResult failure(ArtifactAst application, ComponentLocation mainFlow, List<I18nMessage> errorMessages, Map<ComponentLocation, TypedChainComponent> partialInfo, Set<ComponentLocation> interruptedChains, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        return new DefaultTypePropagationResult(false, application, mainFlow, partialInfo, interruptedChains, errorMessages, Optional.empty(), expressionLanguageMetadataService);
    }

    public static DefaultTypePropagationResult failure(ArtifactAst application, ComponentLocation mainFlow, List<I18nMessage> errorMessages) {
        return new DefaultTypePropagationResult(false, application, mainFlow, Collections.emptyMap(), Collections.emptySet(), errorMessages, Optional.empty(), null);
    }

    public boolean isValid() {
        return this.success;
    }

    public Optional<TypedChainComponent> getTypedComponent(ComponentLocation location) {
        if (!this.info.containsKey(location)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.info.get(location));
    }

    public Stream<TypePropagationResult.ComponentPropagationResult> getComponentPropagationResults() {
        return this.info.entrySet().stream().map(entry -> new DefaultComponentPropagationResult((ComponentLocation)entry.getKey(), (TypedChainComponent)entry.getValue()));
    }

    public List<I18nMessage> failureMessages() {
        return this.failures;
    }

    public Map<ComponentLocation, ComponentConditions> retrieveConditions() {
        return (Map)this.cmpConditions.get();
    }

    private Map<ComponentLocation, ComponentConditions> lazyRetrieveConditions(Optional<MuleEventMetadataType> apikitOutput) {
        Map<ComponentLocation, ConditionsBuilder> conditions = this.info.keySet().stream().collect(Collectors.toMap(loc -> loc, ast -> new ConditionsBuilder()));
        this.toAst.forEach((location, componentAst) -> this.analyzeParameterForComponent((ComponentLocation)location, (ComponentAst)componentAst, conditions, Optional.empty()));
        this.toAst.keySet().stream().filter(location -> this.toAst.get(location).getModel(SourceModel.class).isPresent()).findFirst().ifPresent(location -> this.analyzeParameterForComponent((ComponentLocation)location, this.toAst.get(location), conditions, Optional.ofNullable(this.info.get(DefaultTypePropagationResult.flowLocation(location)))));
        apikitOutput.ifPresent(type -> this.setApiKitConditions(conditions, (MuleEventMetadataType)type));
        return conditions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ConditionsBuilder)entry.getValue()).build()));
    }

    private void setApiKitConditions(Map<ComponentLocation, ConditionsBuilder> conditions, MuleEventMetadataType eventType) {
        ComponentAst mainFlowAst = this.toAst.get(this.mainFlow);
        eventType.getMessageType().getPayloadType().ifPresent(payloadType -> this.addConditions(conditions, "payload", mainFlowAst, Optional.of(this.info.get(this.mainFlow).getPayloadType()), null, (MetadataType)payloadType));
        eventType.getMessageType().getAttributesType().ifPresent(attrType -> this.addConditions(conditions, "attributes", mainFlowAst, this.info.get(this.mainFlow).getAttributesType(), null, (MetadataType)attrType));
        eventType.getVariables().getFields().forEach(varType -> {
            String varName = varType.getKey().getName().toString();
            Optional<TypedEventField> actualVariableTyping = Optional.ofNullable((TypedEventField)this.info.get(this.mainFlow).getOutputVarTypes().get(varName));
            this.addConditions(conditions, "vars." + varName, mainFlowAst, actualVariableTyping, null, varType.getValue());
        });
    }

    private static ComponentLocation flowLocation(ComponentLocation location) {
        return new DefaultComponentLocation(Optional.of(location.getRootContainerName()), Collections.singletonList((DefaultComponentLocation.DefaultLocationPart)location.getParts().get(0)));
    }

    private void analyzeParameterForComponent(ComponentLocation location, ComponentAst componentAst, Map<ComponentLocation, ConditionsBuilder> conditions, Optional<TypedChainComponent> flowOutput) {
        TypedChainComponent typedChainComponent = flowOutput.orElse(this.info.get(location));
        this.info.get(location).getMetadataTypesDescriptor().map(ComponentMetadataTypesDescriptor::getInputMetadata).ifPresent(inputMetadata -> inputMetadata.forEach((param, expectedType) -> componentAst.getParameters().stream().filter(parameterAst -> parameterAst.getModel().getName().equals(param)).findFirst().ifPresent(parameterAst -> {
            if (flowOutput.isPresent()) {
                this.analyzeParameterSource(conditions, componentAst, typedChainComponent, (ComponentParameterAst)parameterAst, (MetadataType)expectedType);
            } else {
                this.analyzeParameter(conditions, componentAst, typedChainComponent, (ComponentParameterAst)parameterAst, (MetadataType)expectedType);
            }
        })));
    }

    private void analyzeParameter(Map<ComponentLocation, ConditionsBuilder> conditions, ComponentAst componentAst, TypedChainComponent typedChainComponent, ComponentParameterAst parameterAst, MetadataType expectedType) {
        if (parameterAst.getModel().getExpressionSupport().equals((Object)ExpressionSupport.NOT_SUPPORTED)) {
            return;
        }
        if (!parameterAst.getValue().isLeft()) {
            return;
        }
        String paramExpression = (String)parameterAst.getValue().getLeft();
        if (paramExpression == null) {
            return;
        }
        if (CoreUtils.isErrorResponseParameterOfSource(parameterAst, componentAst) || CoreUtils.isSuccessResponseParameterOfSource(parameterAst, componentAst)) {
            return;
        }
        MuleEventMetadataTypeBuilder builder = new MuleEventMetadataTypeBuilder();
        this.expressionLanguageMetadataService.getInputType(paramExpression, expectedType, builder, ExpressionUtils.createMessageCallback(new ArrayList<String>()));
        MuleEventMetadataType calculatedInput = builder.build();
        calculatedInput.getMessageType().getPayloadType().ifPresent(type -> this.addConditions(conditions, "payload", componentAst, typedChainComponent.getInputPayloadType(), parameterAst.getModel(), (MetadataType)type));
        calculatedInput.getMessageType().getAttributesType().ifPresent(type -> this.addConditions(conditions, "attributes", componentAst, typedChainComponent.getInputAttributesType(), parameterAst.getModel(), (MetadataType)type));
        calculatedInput.getVariables().getFields().forEach(variable -> {
            String varName = variable.getKey().getName().toString();
            Optional<TypedEventField> actualVariableTyping = Optional.ofNullable((TypedEventField)typedChainComponent.getVarsInScopeTypes().get(varName));
            this.addConditions(conditions, "vars." + varName, componentAst, actualVariableTyping, parameterAst.getModel(), variable.getValue());
        });
    }

    private void analyzeParameterSource(Map<ComponentLocation, ConditionsBuilder> conditions, ComponentAst componentAst, TypedChainComponent typedChainComponent, ComponentParameterAst parameterAst, MetadataType expectedType) {
        if (parameterAst.getModel().getExpressionSupport().equals((Object)ExpressionSupport.NOT_SUPPORTED)) {
            return;
        }
        if (!parameterAst.getValue().isLeft()) {
            return;
        }
        String paramExpression = (String)parameterAst.getValue().getLeft();
        if (paramExpression == null) {
            return;
        }
        if (!CoreUtils.isErrorResponseParameterOfSource(parameterAst, componentAst) && !CoreUtils.isSuccessResponseParameterOfSource(parameterAst, componentAst)) {
            return;
        }
        MuleEventMetadataTypeBuilder builder = new MuleEventMetadataTypeBuilder();
        this.expressionLanguageMetadataService.getInputType(paramExpression, expectedType, builder, ExpressionUtils.createMessageCallback(new ArrayList<String>()));
        MuleEventMetadataType calculatedInput = builder.build();
        calculatedInput.getMessageType().getPayloadType().ifPresent(type -> this.addConditions(conditions, "payload", componentAst, Optional.of(typedChainComponent.getPayloadType()), parameterAst.getModel(), (MetadataType)type));
        calculatedInput.getMessageType().getAttributesType().ifPresent(type -> this.addConditions(conditions, "attributes", componentAst, typedChainComponent.getAttributesType(), parameterAst.getModel(), (MetadataType)type));
        calculatedInput.getVariables().getFields().forEach(variable -> {
            String varName = variable.getKey().getName().toString();
            Optional<TypedEventField> actualVariableTyping = Optional.ofNullable((TypedEventField)typedChainComponent.getOutputVarTypes().get(varName));
            this.addConditions(conditions, "vars." + varName, componentAst, actualVariableTyping, parameterAst.getModel(), variable.getValue());
        });
    }

    private void addConditions(Map<ComponentLocation, ConditionsBuilder> conditions, String bindingName, ComponentAst componentAst, Optional<TypedEventField> typedEventField, ParameterModel paramModel, MetadataType type) {
        if (paramModel != null && CoreUtils.skipConditionsFor(componentAst, paramModel)) {
            return;
        }
        if (type.equals(ANY_TYPE)) {
            return;
        }
        Optional<ComponentLocation> conditionAt = typedEventField.flatMap(TypedEventField::getLastValueDefinitionLocation).filter(this.toAst::containsKey);
        conditionAt.ifPresent(loc -> {
            if (CoreUtils.isCoreCollectionBasedScopeOrRouter(this.toAst.get(loc)) && this.hierarchyVerifier.isChildElement((ComponentLocation)loc, componentAst.getLocation())) {
                ((ConditionsBuilder)conditions.get(loc)).getCoreCollectionPreCondition().ifPresent(cond -> {
                    DefaultBindingCondition bindingCondition = (DefaultBindingCondition)cond;
                    bindingCondition.updateType((MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of(type).build());
                });
            }
        });
        conditionAt = conditionAt.filter(loc -> CoreUtils.sameLevelOfErrorHandling(componentAst.getLocation(), loc)).map(loc -> {
            if (this.hierarchyVerifier.isChildElement((ComponentLocation)loc, componentAst.getLocation())) {
                return loc;
            }
            if (CoreUtils.isCorePassThroughScope(loc)) {
                return this.realModifier(this.toAst.get(loc), bindingName).orElseGet(() -> this.modifierOfInput((ComponentLocation)loc, componentAst.getLocation(), bindingName).orElse((ComponentLocation)loc));
            }
            return this.firstNonVoidOperation((ComponentLocation)loc, componentAst.getLocation(), bindingName);
        });
        if (conditionAt.isPresent() && CoreUtils.isCorePassThroughRouter(conditionAt.get())) {
            Reference addConditionToInputOfRouter = new Reference((Object)false);
            this.toAst.get(conditionAt.get()).directChildren().forEach(childChain -> {
                if (this.interruptedChains.contains(childChain.getLocation())) {
                    return;
                }
                Optional<ComponentLocation> modifier = this.realModifier((ComponentAst)childChain, bindingName);
                if (!modifier.isPresent()) {
                    addConditionToInputOfRouter.set((Object)true);
                    return;
                }
                this.addConditions(conditions, bindingName, componentAst, this.outputTypedEventField(bindingName, modifier.get()), paramModel, type);
            });
            if (!((Boolean)addConditionToInputOfRouter.get()).booleanValue()) {
                return;
            }
            conditionAt = this.modifierOfInput(conditionAt.get(), componentAst.getLocation(), bindingName);
        }
        DefaultBindingCondition condition = new DefaultBindingCondition(componentAst.getLocation(), conditionAt, paramModel, bindingName, type);
        conditions.get(componentAst.getLocation()).withPreCondition(condition);
        conditionAt.ifPresent(locationAt -> ((ConditionsBuilder)conditions.get(locationAt)).withPostCondition(condition));
    }

    private Optional<ComponentLocation> modifierOfInput(ComponentLocation location, ComponentLocation forLocation, String binding) {
        return this.inputTypedEventField(binding, location).flatMap(TypedEventField::getLastValueDefinitionLocation).map(loc -> this.firstNonVoidOperation((ComponentLocation)loc, forLocation, binding));
    }

    private ComponentLocation firstNonVoidOperation(ComponentLocation location, ComponentLocation forLocation, String binding) {
        boolean theComponentIsVoid = CoreUtils.isOrBehavesLikeVoidOperationForBinding(this.toAst.get(location), binding);
        boolean upToCommonSiblingItIsNotVoid = this.hierarchyVerifier.allUpToCommonSibling(location, forLocation, loc -> !CoreUtils.isOrBehavesLikeVoidOperationForBinding(this.toAst.get(loc), binding));
        if (!theComponentIsVoid && upToCommonSiblingItIsNotVoid) {
            return location;
        }
        return this.inputTypedEventField(binding, location).flatMap(TypedEventField::getLastValueDefinitionLocation).map(loc -> this.firstNonVoidOperation((ComponentLocation)loc, forLocation, binding)).orElse(location);
    }

    private Optional<ComponentLocation> realModifier(ComponentAst chain, String binding) {
        List children = chain.directChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            if (!this.modifiesBinding(binding, ((ComponentAst)children.get(i)).getLocation())) continue;
            ComponentAst modifier = (ComponentAst)children.get(i);
            if (CoreUtils.isCorePassThroughScope(modifier.getLocation())) {
                return this.realModifier(modifier, binding);
            }
            return Optional.of(modifier.getLocation());
        }
        return Optional.empty();
    }

    private Optional<TypedEventField> inputTypedEventField(String binding, ComponentLocation location) {
        Optional<Object> setter = binding.equals("payload") ? this.info.get(location).getInputPayloadType() : (binding.equals("attributes") ? this.info.get(location).getInputAttributesType() : Optional.ofNullable((TypedEventField)this.info.get(location).getVarsInScopeTypes().get(binding.substring("vars.".length()))));
        return setter;
    }

    private Optional<TypedEventField> outputTypedEventField(String binding, ComponentLocation location) {
        Optional<TypedEventField> setter = binding.equals("payload") ? Optional.of(this.info.get(location).getPayloadType()) : (binding.equals("attributes") ? this.info.get(location).getAttributesType() : Optional.ofNullable((TypedEventField)this.info.get(location).getOutputVarTypes().get(binding.substring("vars.".length()))));
        return setter;
    }

    private boolean modifiesBinding(String binding, ComponentLocation location) {
        if (!this.info.containsKey(location)) {
            return false;
        }
        if (binding.equals("payload")) {
            return this.info.get(location).getPayloadType().getLastValueDefinitionLocation().map(loc -> loc.equals(location)).orElse(false);
        }
        if (binding.equals("attributes")) {
            return this.info.get(location).getAttributesType().flatMap(TypedEventField::getLastValueDefinitionLocation).map(loc -> loc.equals(location)).orElse(false);
        }
        TypedEventField varField = (TypedEventField)this.info.get(location).getOutputVarTypes().get(binding.substring("vars.".length()));
        if (varField == null) {
            return false;
        }
        return varField.getLastValueDefinitionLocation().map(loc -> loc.equals(location)).orElse(false);
    }

    private static final class DefaultComponentPropagationResult
    implements TypePropagationResult.ComponentPropagationResult {
        private final ComponentLocation location;
        private final TypedChainComponent typedChainComponent;

        private DefaultComponentPropagationResult(ComponentLocation location, TypedChainComponent typedChainComponent) {
            this.location = location;
            this.typedChainComponent = typedChainComponent;
        }

        public ComponentLocation getLocation() {
            return this.location;
        }

        public TypedChainComponent getTypedChainComponent() {
            return this.typedChainComponent;
        }
    }
}

