/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.override.enrichment.loader.xml;

import java.io.InputStream;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.framework.internal.tooling.type.catalog.util.xml.XmlMatcher;
import org.mule.framework.internal.tooling.type.catalog.util.xml.XmlUtils;
import org.mule.framework.internal.tooling.type.override.declarations.loader.TypeOverrideDeclarationLoaderContext;
import org.mule.framework.internal.tooling.type.override.declarations.loader.xml.ExtensionOperationTypeOverrideDeclarationXmlLoader;
import org.mule.framework.internal.tooling.type.override.declarations.loader.xml.MessageProcessorTypeOverrideDeclarationXmlLoader;
import org.mule.framework.internal.tooling.type.override.declarations.loader.xml.TypeOverrideDeclarationXmlLoader;
import org.mule.framework.internal.tooling.type.override.declarations.model.TypeOverrideDeclaration;
import org.mule.framework.internal.tooling.type.override.enrichment.loader.TypeOverrideLoadingException;
import org.mule.framework.internal.tooling.type.override.enrichment.loader.TypeOverridesRepositoryLoader;
import org.mule.framework.internal.tooling.type.override.enrichment.loader.TypeOverridesRepositoryLoaderContext;
import org.mule.framework.internal.tooling.type.override.enrichment.model.TypeOverrideResolver;
import org.mule.framework.internal.tooling.type.override.enrichment.model.TypeOverridesRepository;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class TypeOverridesRepositoryXmlLoader
implements TypeOverridesRepositoryLoader {
    private static final String NS_TYPES = "http://www.mulesoft.org/schema/mule/types";
    private static final QName ELEM_MULE = new QName("http://www.mulesoft.org/schema/mule/types", "mule");
    private static final QName ELEM_ENRICHMENT = new QName("http://www.mulesoft.org/schema/mule/types", "enrichment");
    private static final String SELECTOR_ATTRIBUTE_NAME = "select";
    private final TypeOverrideDeclarationXmlLoader operationTypeDeclarationXmlLoader = new ExtensionOperationTypeOverrideDeclarationXmlLoader();
    private final TypeOverrideDeclarationXmlLoader processorTypeDeclarationXmlLoader = new MessageProcessorTypeOverrideDeclarationXmlLoader();

    @Override
    public TypeOverridesRepository loadFiles(Iterable<InputStream> files, TypeOverridesRepositoryLoaderContext typeOverridesRepositoryLoaderContext) throws TypeOverrideLoadingException {
        try {
            TypeOverridesRepository repository = new TypeOverridesRepository();
            for (InputStream stream : files) {
                this.load(repository, XmlUtils.parseRootElement(new InputSource(stream)), typeOverridesRepositoryLoaderContext);
            }
            return repository;
        }
        catch (Exception e) {
            throw new TypeOverrideLoadingException("Error while loading type overrides", e);
        }
    }

    private void load(TypeOverridesRepository typeOverridesRepository, Element element, TypeOverridesRepositoryLoaderContext typeOverridesRepositoryLoaderContext) {
        XmlMatcher.match(element, ELEM_MULE).ifPresent(xmlMatcher -> xmlMatcher.matchMany(ELEM_ENRICHMENT).forEach(enrichment -> {
            String select = enrichment.requireAttribute(SELECTOR_ATTRIBUTE_NAME);
            enrichment.matchAll().forEach(value -> {
                TypeOverrideDeclarationLoaderContext ctx = new TypeOverrideDeclarationLoaderContext(typeOverridesRepositoryLoaderContext.getTypesCatalog());
                Optional<TypeOverrideDeclaration> operationOverride = this.operationTypeDeclarationXmlLoader.load(value.element(), ctx);
                Optional<TypeOverrideDeclaration> processorOverride = this.processorTypeDeclarationXmlLoader.load(value.element(), ctx);
                TypeOverrideDeclaration typeOverride = operationOverride.orElse(processorOverride.orElse(null));
                typeOverridesRepository.add(new TypeOverrideResolver(select, typeOverride));
            });
        }));
    }
}

