/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.override.declarations.loader.xml;

import java.util.Optional;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import org.mule.framework.internal.tooling.type.catalog.model.TypesCatalog;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolverException;
import org.mule.framework.internal.tooling.type.catalog.util.xml.XmlMatcher;
import org.mule.framework.internal.tooling.type.override.declarations.loader.TypeOverrideDeclarationLoaderContext;
import org.mule.framework.internal.tooling.type.override.declarations.loader.xml.AbstractTypeOverrideDeclarationXmlLoader;
import org.mule.framework.internal.tooling.type.override.declarations.model.TypeOverrideDeclaration;
import org.mule.framework.internal.tooling.type.override.declarations.model.TypeOverrideDeclarationBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.w3c.dom.Element;

public class MessageProcessorTypeOverrideDeclarationXmlLoader
extends AbstractTypeOverrideDeclarationXmlLoader {
    private static final String NS_TYPES = "http://www.mulesoft.org/schema/mule/types";
    private static final QName ELEM_MP_DECLARATION = new QName("http://www.mulesoft.org/schema/mule/types", "processor-declaration");
    private static final QName ELEM_INPUT_EVENT = new QName("http://www.mulesoft.org/schema/mule/types", "input-event");
    private static final QName ELEM_OUTPUT_EVENT = new QName("http://www.mulesoft.org/schema/mule/types", "output-event");
    private static final QName ELEM_MESSAGE = new QName("http://www.mulesoft.org/schema/mule/types", "message");
    private static final QName ELEM_VARIABLES = new QName("http://www.mulesoft.org/schema/mule/types", "variables");
    private static final QName ELEM_VARIABLE = new QName("http://www.mulesoft.org/schema/mule/types", "variable");
    private static final QName ELEM_PAYLOAD = new QName("http://www.mulesoft.org/schema/mule/types", "payload");
    private static final QName ELEM_ATTRIBUTES = new QName("http://www.mulesoft.org/schema/mule/types", "attributes");
    private static final String ATTR_TYPE = "type";

    @Override
    public Optional<TypeOverrideDeclaration> load(Element element, TypeOverrideDeclarationLoaderContext context) {
        return XmlMatcher.match(element, ELEM_MP_DECLARATION).map(opDeclaration -> {
            TypeOverrideDeclarationBuilder declarationBuilder = TypeOverrideDeclaration.builder();
            opDeclaration.match(ELEM_INPUT_EVENT).ifPresent(inputEvent -> {
                this.foreachVariableType((XmlMatcher)inputEvent, context.getTypesCatalog(), declarationBuilder::withInputVariableType);
                this.loadPayloadType((XmlMatcher)inputEvent, context.getTypesCatalog()).ifPresent(declarationBuilder::withInputPayloadType);
                this.loadAttributesType((XmlMatcher)inputEvent, context.getTypesCatalog()).ifPresent(declarationBuilder::withInputAttributesType);
            });
            opDeclaration.match(ELEM_OUTPUT_EVENT).ifPresent(outputEvent -> {
                this.foreachVariableType((XmlMatcher)outputEvent, context.getTypesCatalog(), declarationBuilder::withOutputVariableType);
                this.loadPayloadType((XmlMatcher)outputEvent, context.getTypesCatalog()).ifPresent(declarationBuilder::withOutputPayloadType);
                this.loadAttributesType((XmlMatcher)outputEvent, context.getTypesCatalog()).ifPresent(declarationBuilder::withOutputAttributesType);
            });
            return declarationBuilder.build();
        });
    }

    private Optional<MetadataType> loadPayloadType(XmlMatcher eventMatcher, TypesCatalog typesCatalog) {
        return this.loadFromMessage(eventMatcher, typesCatalog, ELEM_PAYLOAD);
    }

    private Optional<MetadataType> loadAttributesType(XmlMatcher eventMatcher, TypesCatalog typesCatalog) {
        return this.loadFromMessage(eventMatcher, typesCatalog, ELEM_ATTRIBUTES);
    }

    private Optional<MetadataType> loadFromMessage(XmlMatcher eventMatcher, TypesCatalog typesCatalog, QName elementQName) {
        return eventMatcher.match(ELEM_MESSAGE).flatMap(messageMatcher -> messageMatcher.match(elementQName)).flatMap(attributesMatcher -> {
            String typeExpression = attributesMatcher.requireAttribute(ATTR_TYPE);
            try {
                return Optional.ofNullable(this.resolveType(typeExpression, typesCatalog));
            }
            catch (TypeResolverException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void foreachVariableType(XmlMatcher eventMatcher, TypesCatalog typesCatalog, BiConsumer<String, MetadataType> callback) {
        this.iterateDictionaryOfTypes(eventMatcher, ELEM_VARIABLES, ELEM_VARIABLE, typesCatalog, callback);
    }
}

