/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.override.declarations.loader.xml;

import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.framework.internal.tooling.type.catalog.model.TypesCatalog;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolverException;
import org.mule.framework.internal.tooling.type.catalog.util.xml.XmlMatcher;
import org.mule.framework.internal.tooling.type.override.declarations.loader.xml.TypeOverrideDeclarationXmlLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

public abstract class AbstractTypeOverrideDeclarationXmlLoader
implements TypeOverrideDeclarationXmlLoader {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";

    protected MetadataType resolveType(String typeExpression, TypesCatalog typesCatalog) throws TypeResolverException {
        MetadataType result = null;
        String currentTypeExpression = typeExpression;
        boolean useArray = false;
        if (currentTypeExpression.endsWith("[]")) {
            useArray = true;
            currentTypeExpression = StringUtils.removeEnd((String)currentTypeExpression, (String)"[]");
        }
        String typeIdentifier = currentTypeExpression;
        result = typesCatalog.resolveType(typeIdentifier).orElseThrow(() -> new TypeResolverException(String.format("Failed to resolve type '%s' in expression '%s'.", typeIdentifier, typeExpression)));
        if (useArray) {
            BaseTypeBuilder typeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA);
            result = typeBuilder.arrayType().of(result).build();
        }
        return result;
    }

    protected void iterateDictionaryOfTypes(XmlMatcher enclosingMatcher, QName mapName, QName elemName, TypesCatalog typesCatalog, BiConsumer<String, MetadataType> callback) {
        enclosingMatcher.match(mapName).ifPresent(mapElement -> mapElement.matchMany(elemName).forEach(eachElement -> {
            String name = eachElement.requireAttribute(ATTR_NAME);
            String typeExpression = eachElement.requireAttribute(ATTR_TYPE);
            try {
                callback.accept(name, this.resolveType(typeExpression, typesCatalog));
            }
            catch (TypeResolverException e) {
                throw new RuntimeException(e);
            }
        }));
    }
}

