/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.util.xml;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlMatcher {
    private final Element element;

    public static Optional<XmlMatcher> match(Element element, QName qName) {
        Optional<XmlMatcher> result = Optional.empty();
        if (Objects.equals(element.getNamespaceURI(), qName.getNamespaceURI()) && Objects.equals(element.getLocalName(), qName.getLocalPart())) {
            result = Optional.of(new XmlMatcher(element));
        }
        return result;
    }

    private Stream<Node> nodeStream(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item);
    }

    private XmlMatcher(Element element) {
        Objects.requireNonNull(element, "element");
        this.element = element;
    }

    public Optional<XmlMatcher> match(QName qName) {
        if (qName == null) {
            return Optional.empty();
        }
        return this.matchMany(qName).findFirst();
    }

    public String value() {
        StringBuilder stringBuilder = new StringBuilder();
        this.nodeStream(this.element.getChildNodes()).filter(Text.class::isInstance).map(Node::getTextContent).forEach(stringBuilder::append);
        return stringBuilder.toString();
    }

    public Stream<XmlMatcher> matchMany(QName qName) {
        return this.nodeStream(this.element.getElementsByTagNameNS(qName.getNamespaceURI(), qName.getLocalPart())).filter(Element.class::isInstance).map(Element.class::cast).filter(filteredElem -> qName.equals(new QName(filteredElem.getNamespaceURI(), filteredElem.getLocalName()))).map(XmlMatcher::new);
    }

    public Optional<Attr> matchAttributeNode(String attributeName) {
        Attr attributeNodeNS = this.element.getAttributeNodeNS(null, attributeName);
        return Optional.ofNullable(attributeNodeNS);
    }

    public Optional<String> matchAttribute(String attributeName) {
        Attr attributeNodeNS = this.matchAttributeNode(attributeName).orElse(null);
        return Optional.ofNullable(attributeNodeNS == null ? null : attributeNodeNS.getValue());
    }

    public Element element() {
        return this.element;
    }

    public static Optional<QName> resolveQName(Attr attr) {
        String prefix;
        String uri;
        QName result = null;
        String value = attr.getTextContent();
        String[] split = value.split(":");
        if (split.length == 2 && (uri = attr.lookupNamespaceURI(prefix = split[0])) != null) {
            String localName = split[1];
            result = new QName(uri, localName);
        }
        return Optional.ofNullable(result);
    }

    public String requireAttribute(String attributeName) {
        return this.matchAttribute(attributeName).orElseThrow(() -> new IllegalArgumentException(String.format("Attribute '%s' not found in element '%s'", attributeName, this.element)));
    }

    public Stream<XmlMatcher> matchAll() {
        return this.nodeStream(this.element.getChildNodes()).filter(Element.class::isInstance).map(Element.class::cast).map(XmlMatcher::new);
    }
}

