/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.dw;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public abstract class DwBasedTypeLoader
implements TypeLoader {
    private final TypeLoader delegate;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

    protected DwBasedTypeLoader(File file, ExpressionLanguageMetadataService expressionLanguageMetadataService, MetadataFormat format) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.delegate = this.createDelegate(file, format);
    }

    protected DwBasedTypeLoader(String content, ExpressionLanguageMetadataService expressionLanguageMetadataService, MetadataFormat format) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.delegate = this.createDelegate(content, format);
    }

    protected abstract TypeLoader createDelegate(File var1, MetadataFormat var2);

    protected abstract TypeLoader createDelegate(String var1, MetadataFormat var2);

    public static String getMimeType(MetadataFormat metadataFormat) {
        Objects.requireNonNull(metadataFormat, "metadataFormat");
        return (String)metadataFormat.getValidMimeTypes().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown mime type for " + metadataFormat.getId()));
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        return this.delegate.load(typeIdentifier, typeAlias);
    }

    protected ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return this.expressionLanguageMetadataService;
    }
}

