/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.framework.internal.tooling.type.catalog.model.MetadataFormats;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.CopybookTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.CsvExampleTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.CsvTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.ExcelExampleTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.FixedWidthTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.FlatFileTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.FromDwShapeTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.JavaTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.JsonSchemaTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.JsonTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.MapTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.TypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.XmlSchemaTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.XmlTypeLoaderFactory;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.util.Pair;

public class TypeLoaderRegistry {
    private final Map<Pair<String, String>, TypeLoaderFactory> typeLoaderFactoryMap = new HashMap<Pair<String, String>, TypeLoaderFactory>();

    public TypeLoaderRegistry(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.register(new JsonTypeLoaderFactory());
        this.register(new XmlTypeLoaderFactory());
        this.register(new CsvExampleTypeLoaderFactory(expressionLanguageMetadataService));
        this.register(new ExcelExampleTypeLoaderFactory(expressionLanguageMetadataService));
        this.register(new JsonSchemaTypeLoaderFactory());
        this.register(new XmlSchemaTypeLoaderFactory());
        this.register(new JavaTypeLoaderFactory());
        this.register(new CsvTypeLoaderFactory());
        this.register(new MapTypeLoaderFactory());
        this.register(new CopybookTypeLoaderFactory());
        this.register(new FixedWidthTypeLoaderFactory());
        this.register(new FlatFileTypeLoaderFactory());
        this.register(new FromDwShapeTypeLoaderFactory(MetadataFormats.CSV, expressionLanguageMetadataService));
        this.register(new FromDwShapeTypeLoaderFactory(MetadataFormats.EXCEL, expressionLanguageMetadataService));
        this.register(new FromDwShapeTypeLoaderFactory(MetadataFormats.JAVA, expressionLanguageMetadataService));
        this.register(new FromDwShapeTypeLoaderFactory(MetadataFormats.XML, expressionLanguageMetadataService));
        this.register(new FromDwShapeTypeLoaderFactory(MetadataFormats.JSON, expressionLanguageMetadataService));
    }

    public void register(TypeLoaderFactory typeLoaderFactory) {
        if (this.typeLoaderFactoryMap.put((Pair<String, String>)new Pair((Object)typeLoaderFactory.getTypeFormat(), (Object)typeLoaderFactory.getLoaderFormat()), typeLoaderFactory) != null) {
            throw new IllegalStateException("Type loader factory already registered: " + typeLoaderFactory);
        }
    }

    public Optional<TypeLoaderFactory> getFactory(String typeFormat, String loaderFormat) {
        return Optional.ofNullable(this.typeLoaderFactoryMap.get(new Pair((Object)typeFormat, (Object)loaderFormat)));
    }
}

