/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders;

import java.io.File;
import java.util.Objects;
import org.mule.framework.internal.tooling.type.catalog.model.MetadataFormats;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.ShapeTypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.dw.DwBasedShapeTypeLoader;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class FromDwShapeTypeLoaderFactory
implements ShapeTypeLoaderFactory {
    private final MetadataFormat format;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

    public FromDwShapeTypeLoaderFactory(MetadataFormat format, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        Objects.requireNonNull(format, "format");
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.format = format;
    }

    @Override
    public String getTypeFormat() {
        return this.format.getId();
    }

    @Override
    public String getLoaderFormat() {
        return MetadataFormats.WEAVE.getId();
    }

    @Override
    public TypeLoader createTypeLoader(File file) {
        return new DwBasedShapeTypeLoader(file, this.expressionLanguageMetadataService, this.format);
    }

    @Override
    public TypeLoader createTypeLoader(String content) {
        return new DwBasedShapeTypeLoader(content, this.expressionLanguageMetadataService, this.format);
    }
}

