/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.bindings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.privileged.el.DataWeaveArtifactContext;
import org.mule.runtime.core.privileged.el.MuleInstanceContext;
import org.mule.runtime.core.privileged.el.ServerContext;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;

public class BindingsResolver {
    private static final String GLOBAL_BINDING_MULE = "mule";
    private static final String GLOBAL_BINDING_SERVER = "server";
    private static final String GLOBAL_BINDING_APP = "app";
    private static final String GLOBAL_BINDING_FLOW = "flow";
    private static final String GLOBAL_BINDING_CORRELATION_ID = "correlationId";
    private static final String GLOBAL_BINDING_DATA_TYPE = "dataType";
    private static final String GLOBAL_BINDING_AUTHENTICATION = "authentication";
    private static final String GLOBAL_BINDING_ITEM_SEQUENCE_INFO = "itemSequenceInfo";
    private static final String GLOBAL_BINDING_ERROR = "error";
    private static final String GLOBAL_BINDING_PAYLOAD = "payload";
    private static final String GLOBAL_BINDING_ATTRIBUTES = "attributes";
    private static final String GLOBAL_BINDING_VARS = "vars";
    private static final String GLOBAL_BINDING_PARAMS = "params";
    private static final String GLOBAL_BINDING_MESSAGE = "message";
    private final LazyValue<Map<String, MetadataType>> moduleBindings = new LazyValue(() -> BindingsResolver.createModuleBindings(extensionModels));
    private final LazyValue<Map<String, MetadataType>> globalBindings = new LazyValue(() -> BindingsResolver.createGlobalBindings(extensionModels));
    private static final LazyValue<Map<String, MetadataType>> preCalculatedGlobalBindings = new LazyValue(BindingsResolver::preCalculateGlobalBindings);

    private static Map<String, MetadataType> preCalculateGlobalBindings() {
        HashMap<String, MetadataType> result = new HashMap<String, MetadataType>();
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(BindingsResolver.class.getClassLoader());
        result.put(GLOBAL_BINDING_MULE, typeLoader.load(MuleInstanceContext.class));
        result.put(GLOBAL_BINDING_SERVER, typeLoader.load(ServerContext.class));
        result.put(GLOBAL_BINDING_APP, typeLoader.load(DataWeaveArtifactContext.class));
        result.put(GLOBAL_BINDING_FLOW, typeLoader.load(BindingContextUtils.FlowVariablesAccessor.class));
        AnyType anyType = BindingsResolver.getTypeBuilder().anyType().build();
        ObjectType mapType = BindingsResolver.getTypeBuilder().objectType().open().build();
        result.put(GLOBAL_BINDING_CORRELATION_ID, (MetadataType)BindingsResolver.getTypeBuilder().stringType().build());
        result.put(GLOBAL_BINDING_DATA_TYPE, typeLoader.load(DataType.class));
        result.put(GLOBAL_BINDING_AUTHENTICATION, typeLoader.load(Authentication.class));
        result.put(GLOBAL_BINDING_ITEM_SEQUENCE_INFO, typeLoader.load(ItemSequenceInfo.class));
        result.put(GLOBAL_BINDING_ERROR, typeLoader.load(Error.class));
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = MessageMetadataType.builder();
        messageMetadataTypeBuilder.payload((MetadataType)anyType).build();
        messageMetadataTypeBuilder.attributes((MetadataType)anyType).build();
        result.put(GLOBAL_BINDING_MESSAGE, (MetadataType)messageMetadataTypeBuilder.build());
        result.put(GLOBAL_BINDING_PAYLOAD, (MetadataType)anyType);
        result.put(GLOBAL_BINDING_ATTRIBUTES, (MetadataType)anyType);
        result.put(GLOBAL_BINDING_VARS, (MetadataType)mapType);
        if (MuleFrameworkUtils.isMuleSdkEnabled()) {
            result.put(GLOBAL_BINDING_PARAMS, (MetadataType)mapType);
        }
        return result;
    }

    public BindingsResolver(Set<ExtensionModel> extensionModels) {
    }

    public Map<String, MetadataType> getModuleBindings() {
        return (Map)this.moduleBindings.get();
    }

    public Map<String, MetadataType> getGlobalBindings() {
        return (Map)this.globalBindings.get();
    }

    private static Map<String, MetadataType> createModuleBindings(Set<ExtensionModel> extensionModels) {
        Set<ExtensionModel> filteredExtensionModels = extensionModels.stream().filter(extensionModel -> !extensionModel.getName().equals(GLOBAL_BINDING_MULE)).collect(Collectors.toSet());
        return BindingsResolver.createBindingsFromExtensionModels(filteredExtensionModels);
    }

    private static Map<String, MetadataType> createBindingsFromExtensionModels(Set<ExtensionModel> extensionModels) {
        return BindingsResolver.createBindingsFromExtensionModels(extensionModels, (moduleIdentifier, identifier) -> moduleIdentifier + "::" + identifier);
    }

    private static Map<String, MetadataType> createBindingsFromExtensionModels(Set<ExtensionModel> extensionModels, BiFunction<String, String, String> createName) {
        HashMap<String, MetadataType> result = new HashMap<String, MetadataType>();
        extensionModels.forEach(extensionModel -> {
            String moduleIdentifier = BindingsResolver.createModuleIdentifier(extensionModel);
            extensionModel.getFunctionModels().forEach(functionModel -> {
                FunctionTypeBuilder functionTypeBuilder = BindingsResolver.getFunctionTypeBuilder();
                for (ParameterModel parameterModel : functionModel.getAllParameterModels()) {
                    if (parameterModel.isRequired()) {
                        functionTypeBuilder.addParameterOf(parameterModel.getName(), parameterModel.getType());
                        continue;
                    }
                    functionTypeBuilder.addOptionalParameterOf(parameterModel.getName(), parameterModel.getType());
                }
                functionTypeBuilder.returnType(functionModel.getOutput().getType());
                result.put((String)createName.apply(moduleIdentifier, functionModel.getName()), (MetadataType)functionTypeBuilder.build());
            });
        });
        return result;
    }

    private static Map<String, MetadataType> createGlobalBindings(Set<ExtensionModel> extensionModels) {
        HashMap<String, MetadataType> globalBindings = new HashMap<String, MetadataType>();
        Set<ExtensionModel> filteredExtensionModels = extensionModels.stream().filter(extensionModel -> extensionModel.getName().equals(GLOBAL_BINDING_MULE)).collect(Collectors.toSet());
        globalBindings.putAll(BindingsResolver.createBindingsFromExtensionModels(filteredExtensionModels, (moduleIdentifier, identifier) -> identifier));
        globalBindings.putAll((Map)preCalculatedGlobalBindings.get());
        return Collections.unmodifiableMap(globalBindings);
    }

    private static FunctionTypeBuilder getFunctionTypeBuilder() {
        return BindingsResolver.getTypeBuilder().functionType();
    }

    private static BaseTypeBuilder getTypeBuilder() {
        return new BaseTypeBuilder(MetadataFormat.JAVA);
    }

    private static String createModuleIdentifier(ExtensionModel extensionModel) {
        return StringUtils.capitalize((String)extensionModel.getXmlDslModel().getPrefix());
    }
}

