/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.framework.internal.extension.config.fluent.DietConfigurationCreationCommand;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGeneratorFactory;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;

public class DietConfigurationMetadataCacheIdGenerator
implements ConfigurationMetadataCacheIdGenerator {
    private final ConfigurationMetadataCacheIdGenerator delegate = new ConfigurationMetadataCacheIdGeneratorFactory().create();
    private final Map<String, LazyValue<MetadataCacheId>> configIds = new HashMap<String, LazyValue<MetadataCacheId>>();

    public Optional<MetadataCacheId> getConfigMetadataCacheId(String configName, boolean justProviders) {
        return DietConfigurationMetadataCacheIdGenerator.or(this.delegate.getConfigMetadataCacheId(configName, justProviders), () -> Optional.ofNullable(this.configIds.get(configName)).map(LazyValue::get));
    }

    public void addConfigurations(List<ComponentAst> configAsts) {
        this.delegate.addConfigurations(configAsts);
    }

    public void registerConfiguration(DietConfigurationCreationCommand configurationCreationCommand) {
        this.configIds.put(configurationCreationCommand.getName(), (LazyValue<MetadataCacheId>)new LazyValue(() -> this.resolveFromConfigurationCreationCommand(configurationCreationCommand)));
    }

    public void unregisterConfiguration(String configName) {
        this.configIds.remove(configName);
    }

    private MetadataCacheId resolveFromConfigurationCreationCommand(DietConfigurationCreationCommand configurationCreationCommand) {
        ComponentIdentifier componentIdentifier = this.getComponentIdentifier(configurationCreationCommand.getExtensionModel(), (NamedObject)configurationCreationCommand.getConfigurationModel());
        List<MetadataCacheId> keyParts = this.resolveIdPartsFromComponentParameterization(componentIdentifier, configurationCreationCommand.getConfigurationParameterization());
        keyParts.add(this.resolveFromComponentParameterization(configurationCreationCommand.getExtensionModel(), configurationCreationCommand.getConnectionParameterization()));
        return new MetadataCacheId(keyParts, this.getSourceElementName(componentIdentifier, configurationCreationCommand.getName()));
    }

    private MetadataCacheId resolveFromComponentParameterization(ExtensionModel extensionModel, ComponentParameterization<?> componentParameterization) {
        ComponentIdentifier componentIdentifier = this.getComponentIdentifier(extensionModel, (NamedObject)componentParameterization.getModel());
        return new MetadataCacheId(this.resolveIdPartsFromComponentParameterization(componentIdentifier, componentParameterization), this.getSourceElementName(componentIdentifier, componentParameterization.getModel().getName()));
    }

    private List<MetadataCacheId> resolveIdPartsFromComponentParameterization(ComponentIdentifier componentIdentifier, ComponentParameterization<?> componentParameterization) {
        ArrayList<MetadataCacheId> idParts = new ArrayList<MetadataCacheId>();
        idParts.add(this.resolveComponentIdentifierMetadataCacheId(componentIdentifier));
        this.resolveIdPartsFromParametersRequiredForMetadata(componentParameterization).ifPresent(idParts::add);
        return idParts;
    }

    private static <T> Optional<T> or(Optional<T> original, Supplier<Optional<T>> supplier) {
        if (original.isPresent()) {
            return original;
        }
        return supplier.get();
    }

    private ComponentIdentifier getComponentIdentifier(ExtensionModel extensionModel, NamedObject model) {
        return ComponentIdentifier.builder().name(model.getName()).namespace(extensionModel.getXmlDslModel().getPrefix()).namespaceUri(extensionModel.getXmlDslModel().getNamespace()).build();
    }

    private MetadataCacheId resolveComponentIdentifierMetadataCacheId(ComponentIdentifier componentIdentifier) {
        return new MetadataCacheId(componentIdentifier.hashCode(), componentIdentifier.toString());
    }

    private String getSourceElementName(ComponentIdentifier identifier, String componentId) {
        return identifier.getNamespace() + ":" + identifier.getName() + "[" + componentId + "]";
    }

    private Optional<MetadataCacheId> resolveIdPartsFromParametersRequiredForMetadata(ComponentParameterization<?> componentParameterization) {
        Set<String> parameterNamesRequiredForMetadata = this.parameterNamesRequiredForMetadataCacheId(componentParameterization);
        List parts = componentParameterization.getParameters().entrySet().stream().filter(e -> parameterNamesRequiredForMetadata.contains(((ParameterModel)((Pair)e.getKey()).getSecond()).getName()) && e.getValue() != null).map(e -> {
            if (e.getValue() instanceof ComponentParameterization) {
                return this.resolveIdPartsFromParametersRequiredForMetadata((ComponentParameterization)e.getValue()).orElse(null);
            }
            return new MetadataCacheId(e.getValue().hashCode(), ((ParameterGroupModel)((Pair)e.getKey()).getFirst()).getName() + "-" + ((ParameterModel)((Pair)e.getKey()).getSecond()).getName());
        }).collect(Collectors.toList());
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MetadataCacheId(parts, componentParameterization.getModel().getName()));
    }

    private Set<String> parameterNamesRequiredForMetadataCacheId(ComponentParameterization<?> componentParameterization) {
        ParameterizedModel parameterizedModel = componentParameterization.getModel();
        if (!(parameterizedModel instanceof EnrichableModel)) {
            return Collections.emptySet();
        }
        return ((EnrichableModel)componentParameterization.getModel()).getModelProperty(RequiredForMetadataModelProperty.class).map(mp -> new HashSet(mp.getRequiredParameters())).orElseGet(Collections::emptySet);
    }
}

