/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.dependency;

import com.mulesoft.mule.framework.api.dependency.DependencyResolutionException;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.function.Function;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class LocalDependencyResolver
implements DependencyResolver {
    private final Path mavenRepositoryPath;
    private final DependencyResolver defaultDependencyResolver;

    public LocalDependencyResolver(Path mavenRepositoryPath) {
        this.mavenRepositoryPath = mavenRepositoryPath;
        this.defaultDependencyResolver = DependencyResolver.defaultDependencyResolver((MavenConfiguration)new MavenConfiguration.MavenConfigurationBuilder().offlineMode(true).localMavenRepositoryLocation(mavenRepositoryPath.toFile()).build());
    }

    public BundleDependency resolveFor(BundleDescriptor descriptor) throws DependencyResolutionException {
        BundleDependency resolvedDescriptor = this.defaultDependencyResolver.resolveArtifact(descriptor);
        if (LocalDependencyResolver.isPackagedDependency(resolvedDescriptor)) {
            return LocalDependencyResolver.getDependencyFromDescriptor(resolvedDescriptor, this.mavenRepositoryPath);
        }
        return this.defaultDependencyResolver.resolveFor(descriptor);
    }

    public BundleDependency resolveArtifact(BundleDescriptor descriptor) throws DependencyResolutionException {
        return this.defaultDependencyResolver.resolveArtifact(descriptor);
    }

    public void dispose() {
        this.defaultDependencyResolver.dispose();
    }

    private static BundleDependency getDependencyFromDescriptor(BundleDependency bundleDependency, Path localRepositoryLocation) {
        ClassLoaderModel classLoaderModel = ClassLoaderModelJsonSerializer.deserialize((File)LocalDependencyResolver.getClassLoaderModelDescriptor(new File(bundleDependency.getBundleUri())));
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(new BundleDescriptor.Builder().setArtifactId(bundleDependency.getDescriptor().getArtifactId()).setGroupId(bundleDependency.getDescriptor().getGroupId()).setClassifier((String)bundleDependency.getDescriptor().getClassifier().orElse(null)).setType(bundleDependency.getDescriptor().getType()).setVersion(bundleDependency.getDescriptor().getVersion()).setBaseVersion(bundleDependency.getDescriptor().getVersion()).build()).setScope(BundleScope.COMPILE).setBundleUri(bundleDependency.getBundleUri());
        classLoaderModel.getDependencies().stream().map(mulePluginDependency -> LocalDependencyResolver.createBundleDependencyFromPackagerDependency(uri -> new File(localRepositoryLocation.getParent().toFile(), uri.toString()).toURI()).apply((Artifact)mulePluginDependency)).forEach(arg_0 -> ((BundleDependency.Builder)builder).addTransitiveDependency(arg_0));
        return builder.build();
    }

    private static Function<Artifact, BundleDependency> createBundleDependencyFromPackagerDependency(Function<URI, URI> uriResolver) {
        return d -> {
            URI bundle = d.getUri();
            if (!d.getUri().isAbsolute()) {
                bundle = (URI)uriResolver.apply(d.getUri());
            }
            return new BundleDependency.Builder().setDescriptor(new BundleDescriptor.Builder().setArtifactId(d.getArtifactCoordinates().getArtifactId()).setGroupId(d.getArtifactCoordinates().getGroupId()).setClassifier(d.getArtifactCoordinates().getClassifier()).setType(d.getArtifactCoordinates().getType()).setVersion(d.getArtifactCoordinates().getVersion()).setBaseVersion(d.getArtifactCoordinates().getVersion()).build()).setScope(BundleScope.COMPILE).setBundleUri(bundle).build();
        };
    }

    private static boolean isPackagedDependency(BundleDependency bundleDependency) {
        if (bundleDependency.getBundleUri() == null) {
            return false;
        }
        return LocalDependencyResolver.getClassLoaderModelDescriptor(new File(bundleDependency.getBundleUri())).exists();
    }

    private static File getClassLoaderModelDescriptor(File artifactFile) {
        return new File(artifactFile.getParent(), "classloader-model.json");
    }
}

