/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.application;

import com.mulesoft.mule.framework.api.MuleFramework;
import com.mulesoft.mule.framework.api.builder.FrameworkApplicationConfigurer;
import com.mulesoft.mule.framework.api.builder.PluginBuilder;
import com.mulesoft.mule.framework.api.builder.PropertiesResolverConfigurer;
import com.mulesoft.mule.framework.api.dependency.DependencyResolutionException;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.mule.framework.internal.builder.application.AbstractFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.application.DefaultFrameworkApplication;
import org.mule.framework.internal.builder.application.DietPluginBuilder;
import org.mule.framework.internal.builder.application.FromPluginsFrameworkApplication;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.util.DependenciesUtils;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorCreator;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginModelResolver;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public class FrameworkApplicationFromPluginsConfigurer
extends AbstractFrameworkApplicationConfigurer {
    private static final String EMPTY_PROJECT_NAME = "<empty>";
    private static final org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor EMPTY_APP_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("com.mulesoft.fwk.temp").setArtifactId("<empty>").setVersion("0.0.1").setBaseVersion("0.0.1").setType("jar").setClassifier("mule-application").build();
    private List<Path> resourcesPaths = Collections.emptyList();
    private Path classPathEntry;
    private final PluginModelResolver pluginModelResolver = PluginModelResolver.pluginModelResolver();
    private final List<DietPluginBuilder> pluginBuilders = new ArrayList<DietPluginBuilder>();

    @Override
    public FrameworkApplicationConfigurer withConfigurations() {
        throw new IllegalStateException("In order to create configurations an artifact AST must be provided.");
    }

    @Override
    public FrameworkApplicationConfigurer disableDslValidations() {
        throw new UnsupportedOperationException("'disableDslValidations' not supported when building from plugins");
    }

    @Override
    public FrameworkApplicationConfigurer withPropertiesResolver(Consumer<PropertiesResolverConfigurer> configurer) {
        throw new UnsupportedOperationException("'withPropertiesResolver' not supported when building from plugins");
    }

    public FrameworkApplicationConfigurer withResources(List<Path> resources) {
        if (resources == null) {
            throw new IllegalArgumentException("'resources' cannot be null");
        }
        if (!this.resourcesPaths.isEmpty()) {
            throw new IllegalStateException("'resources' is already set");
        }
        this.resourcesPaths = resources;
        return this;
    }

    public FrameworkApplicationConfigurer withJavaClasses(Path classPathEntry) {
        if (classPathEntry == null) {
            throw new IllegalArgumentException("'classPathEntry' cannot be null");
        }
        if (this.classPathEntry != null) {
            throw new IllegalStateException("'classPathEntry' is already set");
        }
        this.classPathEntry = classPathEntry;
        return this;
    }

    public PluginBuilder withPlugin(String groupId, String artifactId, String version) {
        BundleDescriptor pluginBundleDescriptor = new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setBaseVersion(version).setType("jar").setClassifier("mule-plugin").build();
        DietPluginBuilder pluginBuilder = new DietPluginBuilder(this, pluginBundleDescriptor);
        this.pluginBuilders.add(pluginBuilder);
        return pluginBuilder;
    }

    @Override
    public FrameworkApplicationConfigurer withDomain(Function<BundleDescriptor, MuleFramework> domainMuleFrameworkResolver) {
        throw new UnsupportedOperationException("'withDomain' not supported when building from plugins");
    }

    @Override
    protected void validateConfigurer(InternalConfigurationsCreationConfigurer configsCreationConfigurer) {
        if (configsCreationConfigurer.getArtifactAst() == null) {
            throw new IllegalStateException("In order to create configurations an artifact AST must be provided.");
        }
    }

    @Override
    protected DefaultFrameworkApplication getFrameworkApplication(MuleDeployableArtifactClassLoader applicationClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations, UnaryOperator<String> propertiesResolver, MavenConfiguration mavenConfiguration) {
        return new FromPluginsFrameworkApplication(applicationClassLoader, configsCreationConfigurer, this.getWorkingDirectory(), dslValidations);
    }

    @Override
    protected ApplicationDescriptor createApplicationDescriptor(Supplier<DependencyResolver> dependencyResolver, Map<String, String> deploymentProperties, Path classPathEntry, Set<URL> folderUrls, MavenConfiguration mavenConfiguration) {
        Path createTempDirectory;
        try {
            createTempDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        DependencyResolver dr = dependencyResolver.get();
        HashMap<Pair<String, String>, org.mule.maven.pom.parser.api.model.BundleDependency> dependencies = new HashMap<Pair<String, String>, org.mule.maven.pom.parser.api.model.BundleDependency>();
        HashMap<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<BundleDependency>> additionalPluginDependencies = new HashMap<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<BundleDependency>>();
        for (DietPluginBuilder pluginBuilder : this.pluginBuilders) {
            try {
                org.mule.maven.pom.parser.api.model.BundleDependency resolvedPluginDependency = dr.resolveFor(pluginBuilder.getPluginDependency());
                this.addDependency(dependencies, resolvedPluginDependency);
                resolvedPluginDependency.getTransitiveDependencies().stream().filter(transitiveDependency -> transitiveDependency.getDescriptor().isPlugin()).forEach(transitiveDependency -> this.addDependency(dependencies, this.transitiveToPluginDependency((org.mule.maven.pom.parser.api.model.BundleDependency)transitiveDependency)));
                if (pluginBuilder.getAdditionalDependencies().isEmpty()) continue;
                LinkedHashMap<Pair<String, String>, org.mule.maven.pom.parser.api.model.BundleDependency> resolvedAdditionalDependencies = new LinkedHashMap<Pair<String, String>, org.mule.maven.pom.parser.api.model.BundleDependency>();
                for (BundleDescriptor additionalDependencyDescriptor : pluginBuilder.getAdditionalDependencies()) {
                    this.addAdditionalPluginDependencies(resolvedAdditionalDependencies, dr.resolveFor(additionalDependencyDescriptor));
                }
                additionalPluginDependencies.put(DependenciesUtils.mavenToMuleDescriptor(resolvedPluginDependency.getDescriptor()), DependenciesUtils.mavenToMuleDependencies(new ArrayList<org.mule.maven.pom.parser.api.model.BundleDependency>(resolvedAdditionalDependencies.values())));
            }
            catch (DependencyResolutionException e) {
                throw new IllegalArgumentException(e);
            }
        }
        ArrayList<String> resourcesNames = new ArrayList<String>();
        this.buildResourcesUrls(this.resourcesPaths, folderUrls, resourcesNames);
        MuleApplicationModel model = (MuleApplicationModel)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)new MuleApplicationModel.MuleApplicationModelBuilder().setName(EMPTY_PROJECT_NAME)).setMinMuleVersion("4.5.0")).setRequiredProduct(Product.MULE_EE)).withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.singletonMap("exportedResources", resourcesNames)))).build();
        DeployableProjectModel wrapperAppModel = new DeployableProjectModel(Collections.emptyList(), Collections.emptyList(), this.resourcesPaths, EMPTY_APP_BUNDLE_DESCRIPTOR, () -> model, createTempDirectory.toFile(), DependenciesUtils.mavenToMuleDependencies(new ArrayList<org.mule.maven.pom.parser.api.model.BundleDependency>(dependencies.values())), Collections.emptySet(), additionalPluginDependencies);
        wrapperAppModel.validate();
        return DeployableArtifactDescriptorFactory.defaultArtifactDescriptorFactory().createApplicationDescriptor(wrapperAppModel, deploymentProperties, this.pluginModelResolver, PluginDescriptorResolver.pluginDescriptorResolver(), DomainDescriptorResolver.noDomainDescriptorResolver(), DeployableArtifactDescriptorCreator.applicationDescriptorCreator());
    }

    private org.mule.maven.pom.parser.api.model.BundleDependency transitiveToPluginDependency(org.mule.maven.pom.parser.api.model.BundleDependency transitiveDependency) {
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(transitiveDependency.getDescriptor()).setScope(transitiveDependency.getScope()).setBundleUri(transitiveDependency.getBundleUri());
        HashSet<org.mule.maven.pom.parser.api.model.BundleDependency> transitiveDeps = new HashSet<org.mule.maven.pom.parser.api.model.BundleDependency>();
        this.getTransitiveDependencies(transitiveDependency, transitiveDeps);
        transitiveDeps.forEach(arg_0 -> ((BundleDependency.Builder)builder).addTransitiveDependency(arg_0));
        return builder.build();
    }

    private void getTransitiveDependencies(org.mule.maven.pom.parser.api.model.BundleDependency bundleDependency, Set<org.mule.maven.pom.parser.api.model.BundleDependency> transitiveDeps) {
        transitiveDeps.addAll(bundleDependency.getTransitiveDependencies());
        bundleDependency.getTransitiveDependencies().forEach(transitiveDependency -> this.getTransitiveDependencies((org.mule.maven.pom.parser.api.model.BundleDependency)transitiveDependency, transitiveDeps));
    }

    private void addAdditionalPluginDependencies(Map<Pair<String, String>, org.mule.maven.pom.parser.api.model.BundleDependency> resolvedAdditionalDependencies, org.mule.maven.pom.parser.api.model.BundleDependency resolvedAdditionalDependency) {
        this.addDependency(resolvedAdditionalDependencies, resolvedAdditionalDependency);
        resolvedAdditionalDependency.getTransitiveDependencies().stream().filter(transitiveDependency -> BundleScope.COMPILE.equals((Object)transitiveDependency.getScope())).forEach(transitiveDependency -> this.addAdditionalPluginDependencies(resolvedAdditionalDependencies, (org.mule.maven.pom.parser.api.model.BundleDependency)transitiveDependency));
    }

    private void buildResourcesUrls(List<Path> resources, Set<URL> folderUrls, List<String> resourcesNames) {
        HashSet resourcesNamesSet = new HashSet();
        resources.forEach(resourceFolder -> {
            try {
                File resourceFile = resourceFolder.toFile();
                if (!resourceFile.exists()) {
                    throw new IllegalArgumentException(resourceFile.getName() + " not exists");
                }
                if (!resourceFile.isDirectory()) {
                    folderUrls.add(resourceFile.getParentFile().toURI().toURL());
                    if (resourcesNamesSet.contains(resourceFile.getName())) {
                        throw new IllegalArgumentException("Duplicated resources: " + resourceFile.getName());
                    }
                    resourcesNamesSet.add(resourceFile.getName());
                } else {
                    folderUrls.add(resourceFile.toURI().toURL());
                    Files.walk(resourceFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(file -> resourceFolder.relativize((Path)file).toString()).forEach(fileName -> {
                        if (resourcesNamesSet.contains(fileName)) {
                            throw new IllegalArgumentException("Duplicated resources: " + resourceFile.getName());
                        }
                        resourcesNamesSet.add(fileName);
                    });
                }
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        resourcesNames.addAll(resourcesNamesSet);
    }

    private void addDependency(Map<Pair<String, String>, org.mule.maven.pom.parser.api.model.BundleDependency> dependencies, org.mule.maven.pom.parser.api.model.BundleDependency dependency) {
        Pair artifactId = new Pair((Object)dependency.getDescriptor().getGroupId(), (Object)dependency.getDescriptor().getArtifactId());
        if (dependencies.containsKey(artifactId) && !MuleFrameworkUtils.mustOverrideArtifact(dependencies.get(artifactId).getDescriptor(), dependency.getDescriptor())) {
            return;
        }
        dependencies.put((Pair<String, String>)artifactId, dependency);
    }
}

