/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal;

import com.mulesoft.mule.framework.api.extension.config.ConfigurationHandler;
import com.mulesoft.mule.framework.api.extension.config.fluent.ConfigurationCreationCommand;
import com.mulesoft.mule.framework.api.extension.connection.fluent.ConnectionConfigurer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.extension.connection.parser.DietConnectionParserUtils;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DietMuleFrameworkConfigurations {
    private static final Logger LOGGER = LoggerFactory.getLogger(DietMuleFrameworkConfigurations.class);
    private final FrameworkDeployableArtifact frameworkDeployableArtifact;
    private final LazyValue<ArtifactAstDependencyGraph> artifactAstDependencyGraph;
    private final Map<String, Optional<ConfigurationHandler>> configsCreated = new HashMap<String, Optional<ConfigurationHandler>>();
    private final Map<String, Object> configsCreationLocks = new ConcurrentHashMap<String, Object>();

    public DietMuleFrameworkConfigurations(FrameworkDeployableArtifact frameworkDeployableArtifact) {
        this.frameworkDeployableArtifact = frameworkDeployableArtifact;
        this.artifactAstDependencyGraph = new LazyValue(() -> ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)frameworkDeployableArtifact.getArtifactAst()));
    }

    public Collection<ComponentAst> getConfigurations() {
        return this.frameworkDeployableArtifact.getConfigurationsAsts().orElse(Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ConfigurationHandler> getConfigurationHandler(String name, Function<String, Optional<ConfigurationHandler>> configHandlerResolver, ExtensionConfigurationFactory extensionConfigurationFactory) {
        Optional<ConfigurationHandler> configurationHandler = configHandlerResolver.apply(name);
        if (!configurationHandler.isPresent() && !this.configsCreated.containsKey(name)) {
            Object object = this.configsCreationLocks.computeIfAbsent(name, k -> new Object());
            synchronized (object) {
                if (!this.configsCreated.containsKey(name)) {
                    Set totalConfigsAsts = ((ArtifactAstDependencyGraph)this.artifactAstDependencyGraph.get()).getRequiredComponents(name).stream().filter(componentAst -> componentAst.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CONFIG)).filter(componentAst -> componentAst.getComponentId().isPresent()).collect(Collectors.toSet());
                    Set<ComponentAst> requiredConfigsAsts = totalConfigsAsts.stream().filter(componentAst -> !((String)componentAst.getComponentId().get()).equals(name)).collect(Collectors.toSet());
                    requiredConfigsAsts.forEach(requiredConfigAst -> this.getConfigurationHandler((String)requiredConfigAst.getComponentId().get(), configHandlerResolver, extensionConfigurationFactory));
                    configurationHandler = totalConfigsAsts.stream().filter(componentAst -> ((String)componentAst.getComponentId().get()).equals(name)).map(c -> this.createConfig((ComponentAst)c, extensionConfigurationFactory)).findFirst();
                    this.configsCreated.put(name, configurationHandler);
                }
            }
        }
        return configurationHandler;
    }

    protected ConfigurationHandler createConfig(ComponentAst configAst, ExtensionConfigurationFactory extensionConfigurationFactory) {
        String configName = (String)configAst.getComponentId().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Attempted to create a configuration with no name in location '%s'", configAst.getLocation()))));
        LOGGER.info("Creating config `{}`...", (Object)configName);
        ComponentParameterization configModel = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)configAst);
        String extensionName = configAst.getExtensionModel().getName();
        String configModelName = configModel.getModel().getName();
        return extensionConfigurationFactory.createExtensionConfiguration(extensionName, configModelName, command -> {
            command.name(configName);
            configModel.getParameters().forEach((parameter, value) -> command.withParameter(((ParameterGroupModel)parameter.getFirst()).getName(), ((ParameterModel)parameter.getSecond()).getName(), value));
            configAst.directChildrenStream().filter(connectionAst -> connectionAst.getModel(ConnectionProviderModel.class).isPresent()).forEach(connectionAst -> {
                ConnectionProviderModel connectionModel = (ConnectionProviderModel)connectionAst.getModel(ConnectionProviderModel.class).get();
                ConnectionConfigurer connectionConfigurer = command.connectingThrough(connectionModel.getName());
                ComponentParameterization connectionParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)connectionAst);
                ArrayList<Pair<String, Optional<String>>> alreadyProcessedParameters = new ArrayList<Pair<String, Optional<String>>>();
                DietConnectionParserUtils.parseOAuthConfigFromParameterization(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)connectionParameterization, connectionModel, alreadyProcessedParameters);
                DietConnectionParserUtils.parseReconnectionConfigFromParameterization(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)connectionParameterization, alreadyProcessedParameters, configName);
                DietConnectionParserUtils.parsePoolingProfileConfigFromParameterization(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)connectionParameterization, alreadyProcessedParameters);
                DietConnectionParserUtils.parseTlsConfigFromParameterization(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)connectionParameterization, alreadyProcessedParameters);
                connectionParameterization.forEachParameter((paramGroup, param, paramValue) -> {
                    if (!this.isParameterProcessed(paramGroup.getName(), param.getName(), alreadyProcessedParameters)) {
                        connectionConfigurer.withParameter(paramGroup.getName(), param.getName(), paramValue);
                    }
                });
            });
        });
    }

    private boolean isParameterProcessed(String paramGroupName, String paramName, Collection<Pair<String, Optional<String>>> alreadyProcessedParameters) {
        return alreadyProcessedParameters.contains(new Pair((Object)paramGroupName, Optional.empty())) || alreadyProcessedParameters.contains(new Pair((Object)paramGroupName, Optional.of(paramName)));
    }

    public ArtifactAstDependencyGraph getArtifactAstDependencyGraph() {
        return (ArtifactAstDependencyGraph)this.artifactAstDependencyGraph.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigCreated(String configName) {
        Object object = this.configsCreationLocks.computeIfAbsent(configName, k -> new Object());
        synchronized (object) {
            return this.configsCreated.containsKey(configName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeConfig(String configName) {
        Object object = this.configsCreationLocks.computeIfAbsent(configName, k -> new Object());
        synchronized (object) {
            this.configsCreated.remove(configName).ifPresent(t -> {
                try {
                    t.close();
                }
                catch (Exception e) {
                    LOGGER.error("Exception closing connection `" + configName + "`", (Throwable)e);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface ExtensionConfigurationFactory {
        public ConfigurationHandler createExtensionConfiguration(String var1, String var2, Consumer<ConfigurationCreationCommand> var3);
    }
}

