/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.impl.builder;

import com.mulesoft.mule.framework.api.MuleFramework;
import com.mulesoft.mule.framework.api.builder.AbstractMuleFrameworkBuilderFactory;
import com.mulesoft.mule.framework.classpath.ModuleRepositoryGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.mule.framework.internal.builder.DietMuleFrameworkBuilder;
import org.mule.framework.internal.builder.service.MuleFrameworkServiceConfigurerBuilder;
import org.mule.framework.internal.service.SharedServiceLifecycleProxyInvocationHandler;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;

public class DefaultMuleFrameworkBuilderFactory
extends AbstractMuleFrameworkBuilderFactory {
    private static boolean reuseGeneratedModuleRepository = false;
    private static ModuleRepository moduleRepository;
    private static final ArtifactClassLoader CONTAINER_CLASS_LOADER;
    private static final ArtifactClassLoaderResolver CLASS_LOADER_RESOLVER;

    private static File createTempDir() throws IOException {
        File tempFolder = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        File moduleDiscovererTemporaryFolder = new File(tempFolder, ".moduleDiscoverer");
        if (!moduleDiscovererTemporaryFolder.mkdir()) {
            throw new IOException("Error while generating class loaders, cannot create directory " + moduleDiscovererTemporaryFolder.getAbsolutePath());
        }
        return moduleDiscovererTemporaryFolder;
    }

    public MuleFramework.Builder create() {
        if (reuseGeneratedModuleRepository && moduleRepository != null) {
            return this.create(DefaultMuleFrameworkBuilderFactory.class.getClassLoader(), moduleRepository);
        }
        return new DietMuleFrameworkBuilder(CONTAINER_CLASS_LOADER, CLASS_LOADER_RESOLVER, this.getMuleVersion(), this.getMuleServices(), this.getDependencyResolver());
    }

    public MuleFramework.Builder create(ClassLoader parentClassLoader, InputStream moduleRepositoryStream) {
        moduleRepository = ModuleRepositoryGenerator.read((InputStream)moduleRepositoryStream);
        return this.create(parentClassLoader, moduleRepository);
    }

    private MuleFramework.Builder create(ClassLoader parentClassLoader, ModuleRepository moduleRepository) {
        ArtifactClassLoader containerClassLoader = ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)moduleRepository, (ClassLoader)parentClassLoader);
        ArtifactClassLoaderResolver artifactClassLoaderResolver = DefaultMuleFrameworkBuilderFactory.getArtifactClassLoaderResolver(containerClassLoader, moduleRepository);
        return new DietMuleFrameworkBuilder(containerClassLoader, artifactClassLoaderResolver, this.getMuleVersion(), this.getMuleServices(), this.getDependencyResolver());
    }

    private static ArtifactClassLoaderResolver getArtifactClassLoaderResolver(ArtifactClassLoader containerClassLoader, ModuleRepository moduleRepository) {
        return ArtifactClassLoaderResolver.classLoaderResolver((ArtifactClassLoader)containerClassLoader, (ModuleRepository)moduleRepository, name -> {
            try {
                return Files.createTempDirectory("nativeLibs_" + name, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void keepServicesAliveAfterLastFrameworkClosed(boolean keep) {
        SharedServiceLifecycleProxyInvocationHandler.keepServicesAlive(keep);
    }

    public void reuseGeneratedModuleRepository(boolean reuse) {
        reuseGeneratedModuleRepository = reuse;
    }

    public void disposeServices() {
        MuleFrameworkServiceConfigurerBuilder.disposeServices();
    }

    static {
        try {
            ModuleRepository moduleRepository = ModuleRepository.createModuleRepository((File)DefaultMuleFrameworkBuilderFactory.createTempDir());
            CONTAINER_CLASS_LOADER = ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)moduleRepository, (ClassLoader)DietMuleFrameworkBuilder.class.getClassLoader());
            CLASS_LOADER_RESOLVER = DefaultMuleFrameworkBuilderFactory.getArtifactClassLoaderResolver(CONTAINER_CLASS_LOADER, moduleRepository);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

