/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.metadata.internal.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.module.soapkit.metadata.api.Notifier;
import org.mule.module.soapkit.metadata.internal.FlowCoordinateFactory;
import org.mule.module.soapkit.metadata.internal.SoapKitIdentifiers;
import org.mule.module.soapkit.metadata.internal.WsdlHandler;
import org.mule.module.soapkit.metadata.internal.model.Flow;
import org.mule.module.soapkit.metadata.internal.model.FlowCoordinate;
import org.mule.module.soapkit.metadata.internal.model.SoapKitConfig;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.wsdl.parser.model.WsdlModel;

public class ApplicationModelWrapper {
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_SERVICE = "service";
    private static final String PARAMETER_PORT = "port";
    private static final String PARAMETER_WSDL_LOCATION = "wsdlLocation";
    private final ArtifactAst applicationModel;
    private final WsdlHandler wsdlHandler;
    private final Notifier notifier;
    private Map<String, SoapKitConfig> configMap;
    private Map<String, FlowCoordinate> metadataFlows;

    public ApplicationModelWrapper(ArtifactAst applicationModel, WsdlHandler wsdlHandler, Notifier notifier) {
        this.applicationModel = applicationModel;
        this.wsdlHandler = wsdlHandler;
        this.notifier = notifier;
        this.initialize();
    }

    private void initialize() {
        this.loadConfigs();
        this.loadFlows();
    }

    private void loadFlows() {
        List<Flow> flows = this.findFlows();
        FlowCoordinateFactory factory = new FlowCoordinateFactory(this.configMap);
        this.metadataFlows = this.createCoordinates(flows, factory);
    }

    private void loadConfigs() {
        this.configMap = this.applicationModel.topLevelComponentsStream().filter(SoapKitIdentifiers::isSoapKitConfig).map(this::createSoapKitConfig).collect(Collectors.toMap(SoapKitConfig::getName, Function.identity()));
    }

    private Set<String> getConfigNames() {
        return this.configMap.keySet();
    }

    public Collection<SoapKitConfig> getConfigurations() {
        return this.configMap.values();
    }

    private Map<String, FlowCoordinate> createCoordinates(List<Flow> flows, FlowCoordinateFactory factory) {
        return flows.stream().map(flow -> factory.createFromFlowName(flow.getName())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(FlowCoordinate::getFlowName, Function.identity()));
    }

    private SoapKitConfig createSoapKitConfig(ComponentAst componentModel) {
        String name = componentModel.getParameter("General", PARAMETER_NAME).getValue().getRight().toString();
        String service = componentModel.getParameter("Connection", PARAMETER_SERVICE).getValue().getRight().toString();
        String port = componentModel.getParameter("Connection", PARAMETER_PORT).getValue().getRight().toString();
        String wsdlLocation = componentModel.getParameter("Connection", PARAMETER_WSDL_LOCATION).getValue().getRight().toString();
        WsdlHandlerSupplier wsdlSupplier = WsdlHandlerSupplier.create(wsdlLocation, this.wsdlHandler);
        return new SoapKitConfig(name, service, port, wsdlLocation, wsdlSupplier, this.notifier);
    }

    public List<Flow> findFlows() {
        return this.applicationModel.topLevelComponentsStream().filter(SoapKitIdentifiers::isFlow).map(this::createFlow).collect(Collectors.toList());
    }

    private Flow createFlow(ComponentAst componentModel) {
        String flowName = componentModel.getComponentId().orElse(null);
        return new Flow(flowName);
    }

    public Optional<FlowCoordinate> getCoordinatesForFlow(String flowName) {
        return Optional.ofNullable(this.metadataFlows.get(flowName));
    }

    public Optional<SoapKitConfig> getConfig(String configName) {
        if (this.configMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.configMap.getOrDefault(configName, this.configMap.values().iterator().next()));
    }

    private static class WsdlHandlerSupplier
    implements Supplier<Optional<WsdlModel>> {
        private final String configRaml;
        private final WsdlHandler handler;

        private WsdlHandlerSupplier(String configRaml, WsdlHandler handler) {
            this.configRaml = configRaml;
            this.handler = handler;
        }

        private static WsdlHandlerSupplier create(String configRaml, WsdlHandler handler) {
            return new WsdlHandlerSupplier(configRaml, handler);
        }

        @Override
        public Optional<WsdlModel> get() {
            return this.handler.getWsdlModel(this.configRaml);
        }
    }
}

