/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service;

import com.mulesoft.service.http.impl.service.HostNameIpsRing;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HostNameResolver {
    private ConcurrentMap<String, HostNameIpsRing> ipsForHostnames = new ConcurrentHashMap<String, HostNameIpsRing>();
    private final AddressesRingFactory addressesRingFactory;

    public HostNameResolver() {
        this(new AddressesRingFactory(){

            @Override
            public HostNameIpsRing create(String hostName) {
                return new HostNameIpsRing(hostName);
            }
        });
    }

    public HostNameResolver(AddressesRingFactory addressesRingFactory) {
        this.addressesRingFactory = addressesRingFactory;
    }

    private HostNameIpsRing getHostNameIpRing(String hostName) {
        if (!this.ipsForHostnames.containsKey(hostName)) {
            this.ipsForHostnames.putIfAbsent(hostName, this.getAddressesRingFactory().create(hostName));
        }
        return (HostNameIpsRing)this.ipsForHostnames.get(hostName);
    }

    public List<InetAddress> getAddresses(String hostName) throws UnknownHostException {
        return this.getHostNameIpRing(hostName).getIpAddresses();
    }

    public List<InetAddress> getRotatedAddresses(String hostName) throws UnknownHostException {
        return this.getHostNameIpRing(hostName).getRotatedIpAddresses();
    }

    public AddressesRingFactory getAddressesRingFactory() {
        return this.addressesRingFactory;
    }

    public static interface AddressesRingFactory {
        public HostNameIpsRing create(String var1);
    }
}

