/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.ByteArrayOutputStream;

public class FrameCodec {
    private static final int MAX_FRAME_PAYLOAD_LENGTH = 0x100000;
    private final EmbeddedChannel decoderChannel = FrameCodec.createDecoderChannel();
    private final EmbeddedChannel encoderChannel = FrameCodec.createEncoderChannel();

    public WebSocketFrame decode(byte[] encodedRepresentation) {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(encodedRepresentation.length).writeBytes(encodedRepresentation);
        this.decoderChannel.writeOneInbound((Object)byteBuf);
        this.decoderChannel.flushInbound();
        return (WebSocketFrame)this.decoderChannel.readInbound();
    }

    public byte[] encode(WebSocketFrame frame) {
        this.encoderChannel.writeOneOutbound((Object)frame);
        this.encoderChannel.flush();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean readMore = true;
        while (readMore) {
            ByteBuf byteBuf = (ByteBuf)this.encoderChannel.readOutbound();
            if (byteBuf == null) {
                readMore = false;
                continue;
            }
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            byteArrayOutputStream.writeBytes(bytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static EmbeddedChannel createEncoderChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameEncoder(false)});
    }

    private static EmbeddedChannel createDecoderChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameDecoder(false, false, 0x100000, false)});
    }
}

