/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.jms;

import bitronix.tm.resource.jms.DualSessionWrapper;
import bitronix.tm.resource.jms.JmsConnectionHandle;
import com.mulesoft.mule.runtime.bti.internal.jms.BitronixSessionInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.proxy.TargetInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixConnectionInvocationHandler
implements TargetInvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(BitronixConnectionInvocationHandler.class);
    private final Connection connection;

    public BitronixConnectionInvocationHandler(Connection connecton) {
        this.connection = connecton;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking {}", (Object)method);
            }
            if (method.getName().equals("createSession")) {
                Transaction tx = TransactionCoordination.getInstance().getTransaction();
                if (tx != null) {
                    DualSessionWrapper xas = (DualSessionWrapper)this.connection.createSession(((Boolean)args[0]).booleanValue(), ((Integer)args[1]).intValue());
                    return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Session.class, MuleXaObject.class}, (InvocationHandler)((Object)new BitronixSessionInvocationHandler(xas)));
                }
                return this.connection.createSession(false, 1);
            }
            if (method.getName().equals("getHoldObject")) {
                return this.connection;
            }
            return method.invoke((Object)this.connection, args);
        }
        catch (Exception e) {
            throw this.asConnectionException(e);
        }
    }

    private Exception asConnectionException(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (ExceptionUtils.extractConnectionException((Throwable)t).isPresent()) {
            return new RuntimeException(t);
        }
        return new RuntimeException((Throwable)new ConnectionException(t));
    }

    public Object getTargetObject() {
        block3: {
            Connection connection = this.connection;
            if (connection instanceof JmsConnectionHandle) {
                JmsConnectionHandle jmsConnectionHandle = (JmsConnectionHandle)connection;
                try {
                    return jmsConnectionHandle.getXAConnection();
                }
                catch (JMSException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Failed to get XA connection", (Throwable)e);
                }
            }
        }
        return this.connection;
    }
}

