/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.util;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputBufferUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputBufferUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean safeBufferAccess(Input input, Function<Input, Boolean> operation, boolean onException) {
        try (Input tmpInput = new Input(input.getBuffer());){
            tmpInput.setPosition(input.position());
            tmpInput.setLimit(input.limit());
            int remaining = tmpInput.limit() - tmpInput.position();
            if (remaining == 0) {
                boolean result = operation.apply(input);
                input.setPosition(0);
                boolean bl = result;
                return bl;
            }
            boolean bl = operation.apply(tmpInput);
            return bl;
        }
        catch (KryoException e) {
            LOGGER.debug("Failed to read value from stream.");
            return onException;
        }
    }
}

