/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.util.InputBufferUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReentrantReadWriteLockSerializer
extends Serializer<ReentrantReadWriteLock> {
    private static final byte[] SERIALIZED_READ_LOCK_CLASS = new byte[]{106, 97, 118, 97, 46, 117, 116, 105, 108, 46, 99, 111, 110, 99, 117, 114, 114, 101, 110, 116, 46, 108, 111, 99, 107, 115, 46, 82, 101, 101, 110, 116, 114, 97, 110, 116, 82, 101, 97, 100, 87, 114, 105, 116, 101, 76, 111, 99, 107, 36, 82, 101, 97, 100, 76, 111, 99, -21};
    private static final byte[] SERIALIZED_WRITE_LOCK_CLASS = new byte[]{106, 97, 118, 97, 46, 117, 116, 105, 108, 46, 99, 111, 110, 99, 117, 114, 114, 101, 110, 116, 46, 108, 111, 99, 107, 115, 46, 82, 101, 101, 110, 116, 114, 97, 110, 116, 82, 101, 97, 100, 87, 114, 105, 116, 101, 76, 111, 99, 107, 36, 87, 114, 105, 116, 101, 76, 111, 99, -21};
    private static final byte[] SERIALIZED_FAIR_LOCK_CLASS = new byte[]{106, 97, 118, 97, 46, 117, 116, 105, 108, 46, 99, 111, 110, 99, 117, 114, 114, 101, 110, 116, 46, 108, 111, 99, 107, 115, 46, 82, 101, 101, 110, 116, 114, 97, 110, 116, 82, 101, 97, 100, 87, 114, 105, 116, 101, 76, 111, 99, 107, 36, 70, 97, 105, 114, 83, 121, 110, -29};
    private static final byte[] SERIALIZED_UNFAIR_LOCK_CLASS = new byte[]{106, 97, 118, 97, 46, 117, 116, 105, 108, 46, 99, 111, 110, 99, 117, 114, 114, 101, 110, 116, 46, 108, 111, 99, 107, 115, 46, 82, 101, 101, 110, 116, 114, 97, 110, 116, 82, 101, 97, 100, 87, 114, 105, 116, 101, 76, 111, 99, 107, 36, 78, 111, 110, 102, 97, 105, 114, 83, 121, 110, -29};
    private static final int CLASSES_LENGTH_DIFFERENCE = SERIALIZED_UNFAIR_LOCK_CLASS.length - SERIALIZED_FAIR_LOCK_CLASS.length;
    public static final String PARSING_ERROR_MESSAGE = "Couldn't parse instance of ReentrantReadWriteLock";
    private static final byte[] CLASS_AND_NAME_ID = new byte[]{1, 0};
    private static final byte ARTIFACT_ID = -128;
    private final Set<Integer> processNameID = new HashSet<Integer>();
    private boolean isInternalKryoInstance = false;

    public void write(Kryo kryo, Output output, ReentrantReadWriteLock lock) {
        this.writeInternalLock(output, SERIALIZED_READ_LOCK_CLASS, lock.isFair());
        this.writeSync(output, lock.isFair());
        this.writeInternalLock(output, SERIALIZED_WRITE_LOCK_CLASS, lock.isFair());
    }

    private void writeInternalLock(Output output, byte[] serializedClass, boolean isFair) {
        output.writeBytes(CLASS_AND_NAME_ID);
        output.writeBytes(serializedClass);
        output.writeVarInt(1, true);
        this.writeSync(output, isFair);
    }

    private void writeSync(Output output, boolean isFair) {
        output.writeBytes(CLASS_AND_NAME_ID);
        output.writeBytes(isFair ? SERIALIZED_FAIR_LOCK_CLASS : SERIALIZED_UNFAIR_LOCK_CLASS);
        output.writeVarInt(1, true);
        output.writeInt(0, false);
    }

    public ReentrantReadWriteLock read(Kryo kryo, Input input, Class<ReentrantReadWriteLock> type) {
        if (this.isLegacyFormat(input)) {
            return this.readLegacy(kryo, input, type);
        }
        input.skip(CLASS_AND_NAME_ID.length);
        input.skip(SERIALIZED_READ_LOCK_CLASS.length);
        if (input.readVarInt(true) != 1) {
            throw new IllegalStateException(PARSING_ERROR_MESSAGE);
        }
        boolean isFair = this.parseSyncSkipRemainingAndReturnIsFair(input);
        this.parseSync(input, isFair);
        input.skip(CLASS_AND_NAME_ID.length);
        input.skip(SERIALIZED_WRITE_LOCK_CLASS.length);
        if (input.readVarInt(true) != 1) {
            throw new IllegalStateException(PARSING_ERROR_MESSAGE);
        }
        this.parseSync(input, isFair);
        return new ReentrantReadWriteLock(isFair);
    }

    private void parseSync(Input input, boolean isFair) {
        input.skip(CLASS_AND_NAME_ID.length);
        input.skip(isFair ? SERIALIZED_FAIR_LOCK_CLASS.length : SERIALIZED_UNFAIR_LOCK_CLASS.length);
        if (input.readVarInt(true) != 1) {
            throw new IllegalStateException(PARSING_ERROR_MESSAGE);
        }
        input.readInt(false);
    }

    private boolean parseSyncSkipRemainingAndReturnIsFair(Input input) {
        input.skip(CLASS_AND_NAME_ID.length);
        byte[] serializedClassHeader = input.readBytes(SERIALIZED_FAIR_LOCK_CLASS.length);
        boolean isFair = Arrays.equals(SERIALIZED_FAIR_LOCK_CLASS, serializedClassHeader);
        if (!isFair) {
            input.skip(CLASSES_LENGTH_DIFFERENCE);
        }
        if (input.readVarInt(true) != 1) {
            throw new IllegalStateException(PARSING_ERROR_MESSAGE);
        }
        input.readInt(false);
        return isFair;
    }

    public ReentrantReadWriteLock readLegacy(Kryo kryo, Input input, Class<ReentrantReadWriteLock> type) {
        input.readVarInt(true);
        int nameID = input.readVarInt(true);
        if (!this.processNameID.contains(nameID)) {
            input.skip(SERIALIZED_READ_LOCK_CLASS.length);
            if (this.isInternalKryoInstance || this.hasArtifactId(input)) {
                this.isInternalKryoInstance = true;
                input.readByte();
            }
            this.processNameID.add(nameID);
        }
        if (input.readVarInt(true) != 1) {
            throw new IllegalStateException(PARSING_ERROR_MESSAGE);
        }
        kryo.getReferenceResolver().nextReadId(type);
        boolean isFair = this.parseSyncSkipRemainingAndReturnIsFairLegacy(input);
        kryo.getReferenceResolver().nextReadId(type);
        this.parseSyncLegacy(input);
        input.readVarInt(true);
        nameID = input.readVarInt(true);
        if (!this.processNameID.contains(nameID)) {
            input.skip(SERIALIZED_WRITE_LOCK_CLASS.length);
            if (this.isInternalKryoInstance) {
                input.readByte();
            }
            this.processNameID.add(nameID);
        }
        if (input.readVarInt(true) != 1) {
            throw new IllegalStateException(PARSING_ERROR_MESSAGE);
        }
        kryo.getReferenceResolver().nextReadId(type);
        this.parseSyncLegacy(input);
        return new ReentrantReadWriteLock(isFair);
    }

    private void parseSyncLegacy(Input input) {
        input.readVarInt(true);
        int nameID = input.readVarInt(true);
        if (!this.processNameID.contains(nameID)) {
            if (input.readVarInt(true) != 1) {
                throw new IllegalStateException(PARSING_ERROR_MESSAGE);
            }
            this.processNameID.add(nameID);
        }
        input.readInt(false);
    }

    private boolean parseSyncSkipRemainingAndReturnIsFairLegacy(Input input) {
        input.readVarInt(true);
        int nameID = input.readVarInt(true);
        boolean isFair = false;
        if (!this.processNameID.contains(nameID)) {
            isFair = Arrays.equals(SERIALIZED_FAIR_LOCK_CLASS, input.readBytes(SERIALIZED_FAIR_LOCK_CLASS.length));
            if (this.isInternalKryoInstance) {
                input.readByte();
            }
            if (!isFair) {
                input.skip(CLASSES_LENGTH_DIFFERENCE);
            }
            this.processNameID.add(nameID);
        }
        if (input.readVarInt(true) != 1) {
            throw new IllegalStateException(PARSING_ERROR_MESSAGE);
        }
        input.readInt(false);
        return isFair;
    }

    private boolean isLegacyFormat(Input input) {
        return InputBufferUtils.safeBufferAccess(input, stream -> stream.readVarInt(true) != 1 || stream.readVarInt(true) != 0, true);
    }

    private boolean hasArtifactId(Input input) {
        return InputBufferUtils.safeBufferAccess(input, stream -> stream.readByte() == -128, false);
    }
}

