/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.ClosureSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.AtomicBooleanSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.AtomicIntegerSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.AtomicLongSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CaseInsensitiveHashMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CaseInsensitiveMapWrapperSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CharsetSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CollectionDataTypeKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CopyOnWriteCaseInsensitiveMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CursorIteratorProviderKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.CursorStreamProviderKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.EventKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.ExternalizableKryo;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.FunctionDataTypeKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.ImmutableCaseInsensitiveHashMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.ImmutableMultiMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.InputStreamKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.IteratorKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.KryoInstanceFactory;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.LinkedHashMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.MapDataTypeKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.MuleMessageKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.MultiMapKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.SerializableLazyValueSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.SerializerRegister;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.SimpleDataTypeKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.TypedValueKryoSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.UnmodifiableMultiMapSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.AtomicReferenceSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.BulkItemSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.BulkOperationResultSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.DefaultMessageBuilderSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.DefaultMuleAuthenticationSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.DefaultSecurityContextSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.EitherSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.MuleArraysAsListSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.MuleGregorianCalendarSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.MuleMapEntrySerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.MuleSynchronizedCollectionsSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.MuleUnmodifiableCollectionsSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.MuleXmlGregorianCalendarSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.RedeliveryCounterSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.ReentrantReadWriteLockSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.ResultSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.StoreValueSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers.StoredObjectSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyMapSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptySetSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonListSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonMapSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonSetSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.RegexSerializer;
import de.javakaffee.kryoserializers.URISerializer;
import de.javakaffee.kryoserializers.UUIDSerializer;
import de.javakaffee.kryoserializers.cglib.CGLibProxySerializer;
import de.javakaffee.kryoserializers.guava.ArrayListMultimapSerializer;
import de.javakaffee.kryoserializers.guava.HashMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableSetSerializer;
import de.javakaffee.kryoserializers.guava.LinkedHashMultimapSerializer;
import de.javakaffee.kryoserializers.guava.LinkedListMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ReverseListSerializer;
import de.javakaffee.kryoserializers.guava.TreeMultimapSerializer;
import de.javakaffee.kryoserializers.guava.UnmodifiableNavigableSetSerializer;
import de.javakaffee.kryoserializers.jodatime.JodaDateTimeSerializer;
import java.io.InputStream;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationHandler;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.joda.time.DateTime;
import org.mule.runtime.api.bulk.BulkItem;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.DefaultMuleAuthentication;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.SerializableLazyValue;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.mule.runtime.core.internal.event.DefaultEventBuilder;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.mule.runtime.core.internal.metadata.DefaultFunctionDataType;
import org.mule.runtime.core.internal.metadata.DefaultMapDataType;
import org.mule.runtime.core.internal.processor.IdempotentRedeliveryPolicy;
import org.mule.runtime.core.internal.security.DefaultSecurityContext;
import org.mule.runtime.core.internal.util.CopyOnWriteCaseInsensitiveMap;
import org.mule.runtime.core.internal.util.store.MonitoredObjectStoreWrapper;
import org.mule.runtime.core.internal.util.store.PersistentObjectStorePartition;
import org.mule.runtime.core.privileged.metadata.DefaultCollectionDataType;
import org.mule.runtime.core.privileged.metadata.SimpleDataType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKryoInstanceFactory
implements KryoInstanceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKryoInstanceFactory.class);

    @Override
    public Kryo getInstance(ClassLoader executionClassLoader, Optional<ClassLoaderRepository> classLoaderRepository) throws Exception {
        ExternalizableKryo kryo = new ExternalizableKryo(this.getClassResolver(classLoaderRepository));
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        kryo.setClassLoader(executionClassLoader);
        this.addStandardSerializers(kryo);
        if (this.shouldAddMuleSerializers()) {
            this.addMuleSerializers(kryo);
        }
        return kryo;
    }

    protected abstract ClassResolver getClassResolver(Optional<ClassLoaderRepository> var1);

    private void addMuleSerializers(Kryo kryo) throws Exception {
        kryo.register(TypedValue.class, (Serializer)new TypedValueKryoSerializer());
        kryo.register(DefaultMessageBuilder.class, (Serializer)new DefaultMessageBuilderSerializer());
        kryo.register(DefaultMessageBuilder.getMessageImplementationClass(), (Serializer)new MuleMessageKryoSerializer());
        kryo.register(DefaultEventBuilder.InternalEventImplementation.class, (Serializer)new EventKryoSerializer(kryo));
        kryo.register(CopyOnWriteCaseInsensitiveMap.class, (Serializer)new CopyOnWriteCaseInsensitiveMapSerializer());
        kryo.register(CaseInsensitiveMapWrapper.class, (Serializer)new CaseInsensitiveMapWrapperSerializer());
        kryo.register(CaseInsensitiveHashMap.class, (Serializer)new CaseInsensitiveHashMapSerializer());
        kryo.register(LinkedHashMap.class, (Serializer)new LinkedHashMapSerializer());
        kryo.register(SerializedLambda.class);
        kryo.register(ClosureSerializer.Closure.class, (Serializer)new ClosureSerializer());
        ImmutableCaseInsensitiveHashMapSerializer.registerSerializers(kryo);
        kryo.register(SimpleDataType.class, new SimpleDataTypeKryoSerializer(), Math.abs(org.mule.runtime.core.internal.metadata.SimpleDataType.class.getCanonicalName().hashCode()));
        kryo.register(DefaultCollectionDataType.class, (Serializer)new CollectionDataTypeKryoSerializer(), Math.abs(org.mule.runtime.core.internal.metadata.DefaultCollectionDataType.class.getCanonicalName().hashCode()));
        kryo.register(org.mule.runtime.core.privileged.metadata.DefaultMapDataType.class, (Serializer)new MapDataTypeKryoSerializer(), Math.abs(DefaultMapDataType.class.getCanonicalName().hashCode()));
        kryo.register(org.mule.runtime.core.privileged.metadata.DefaultFunctionDataType.class, (Serializer)new FunctionDataTypeKryoSerializer(), Math.abs(DefaultFunctionDataType.class.getCanonicalName().hashCode()));
        kryo.register(MultiMap.class, (Serializer)new MultiMapKryoSerializer());
        ImmutableMultiMapSerializer.registerSerializers(kryo);
        UnmodifiableMultiMapSerializer.registerSerializers(kryo);
        kryo.register(Iterator.class, (Serializer)new IteratorKryoSerializer());
        kryo.register(CursorIteratorProvider.class, (Serializer)new CursorIteratorProviderKryoSerializer());
        kryo.register(InputStream.class, (Serializer)new InputStreamKryoSerializer());
        kryo.register(CursorStreamProvider.class, (Serializer)new CursorStreamProviderKryoSerializer());
        kryo.register(BulkOperationResult.class, new BulkOperationResultSerializer());
        kryo.register(BulkItem.class, new BulkItemSerializer());
        kryo.register(DefaultSecurityContext.class, (Serializer)new DefaultSecurityContextSerializer());
        kryo.register(DefaultMuleAuthentication.class, (Serializer)new DefaultMuleAuthenticationSerializer());
        kryo.register(Either.class, new EitherSerializer());
        kryo.register(PersistentObjectStorePartition.StoreValue.class, new StoreValueSerializer());
        kryo.register(IdempotentRedeliveryPolicy.RedeliveryCounter.class, (Serializer)new RedeliveryCounterSerializer());
        kryo.register(MonitoredObjectStoreWrapper.StoredObject.class, new StoredObjectSerializer());
        kryo.register(Result.class, (Serializer)new ResultSerializer());
        this.registerMuleCustomSerializersViaSpi(kryo);
    }

    public static void registerDataTypeSerializers(Kryo kryo) {
        kryo.register(SimpleDataType.class, new SimpleDataTypeKryoSerializer(), Math.abs(org.mule.runtime.core.internal.metadata.SimpleDataType.class.getCanonicalName().hashCode()));
        kryo.register(DefaultCollectionDataType.class, (Serializer)new CollectionDataTypeKryoSerializer(), Math.abs(org.mule.runtime.core.internal.metadata.DefaultCollectionDataType.class.getCanonicalName().hashCode()));
        kryo.register(org.mule.runtime.core.privileged.metadata.DefaultMapDataType.class, (Serializer)new MapDataTypeKryoSerializer(), Math.abs(DefaultMapDataType.class.getCanonicalName().hashCode()));
        kryo.register(org.mule.runtime.core.privileged.metadata.DefaultFunctionDataType.class, (Serializer)new FunctionDataTypeKryoSerializer(), Math.abs(DefaultFunctionDataType.class.getCanonicalName().hashCode()));
    }

    private void addStandardSerializers(Kryo kryo) throws DatatypeConfigurationException {
        kryo.register(Arrays.asList("").getClass(), (Serializer)new MuleArraysAsListSerializer());
        kryo.register(Collections.EMPTY_LIST.getClass(), (Serializer)new CollectionsEmptyListSerializer());
        kryo.register(Collections.EMPTY_MAP.getClass(), (Serializer)new CollectionsEmptyMapSerializer());
        kryo.register(Collections.EMPTY_SET.getClass(), (Serializer)new CollectionsEmptySetSerializer());
        kryo.register(Collections.singletonList("").getClass(), (Serializer)new CollectionsSingletonListSerializer());
        kryo.register(Collections.singleton("").getClass(), (Serializer)new CollectionsSingletonSetSerializer());
        kryo.register(Collections.singletonMap("", "").getClass(), (Serializer)new CollectionsSingletonMapSerializer());
        kryo.register(GregorianCalendar.class, (Serializer)new MuleGregorianCalendarSerializer());
        kryo.register(this.getXMLGregorianCalendarImplClass(), (Serializer)new MuleXmlGregorianCalendarSerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
        MuleUnmodifiableCollectionsSerializer.registerSerializers(kryo);
        MuleSynchronizedCollectionsSerializer.registerSerializers(kryo);
        kryo.register(Map.Entry.class, (Serializer)new MuleMapEntrySerializer());
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)) {
            kryo.register(Certificate.class, (Serializer)new JavaSerializer());
        }
        kryo.register(CGLibProxySerializer.CGLibProxyMarker.class, (Serializer)new CGLibProxySerializer());
        kryo.register(DateTime.class, (Serializer)new JodaDateTimeSerializer());
        kryo.register(AtomicLong.class, (Serializer)new AtomicLongSerializer());
        kryo.register(AtomicInteger.class, (Serializer)new AtomicIntegerSerializer());
        kryo.register(AtomicBoolean.class, (Serializer)new AtomicBooleanSerializer());
        kryo.register(AtomicReference.class, (Serializer)new AtomicReferenceSerializer());
        CharsetSerializer.register(kryo);
        kryo.register(URI.class, (Serializer)new URISerializer());
        kryo.register(Pattern.class, (Serializer)new RegexSerializer());
        kryo.register(UUID.class, (Serializer)new UUIDSerializer());
        kryo.register(ReentrantReadWriteLock.class, (Serializer)new ReentrantReadWriteLockSerializer());
        kryo.register(SerializableLazyValue.class, (Serializer)new SerializableLazyValueSerializer());
        ImmutableListSerializer.registerSerializers((Kryo)kryo);
        ImmutableSetSerializer.registerSerializers((Kryo)kryo);
        ImmutableMapSerializer.registerSerializers((Kryo)kryo);
        ImmutableMultimapSerializer.registerSerializers((Kryo)kryo);
        ReverseListSerializer.registerSerializers((Kryo)kryo);
        UnmodifiableNavigableSetSerializer.registerSerializers((Kryo)kryo);
        ArrayListMultimapSerializer.registerSerializers((Kryo)kryo);
        HashMultimapSerializer.registerSerializers((Kryo)kryo);
        LinkedHashMultimapSerializer.registerSerializers((Kryo)kryo);
        LinkedListMultimapSerializer.registerSerializers((Kryo)kryo);
        TreeMultimapSerializer.registerSerializers((Kryo)kryo);
    }

    private Class<?> getXMLGregorianCalendarImplClass() throws DatatypeConfigurationException {
        return DatatypeFactory.newInstance().newXMLGregorianCalendar().getClass();
    }

    private void registerMuleCustomSerializersViaSpi(Kryo kryo) {
        StreamSupport.stream(((Iterable)() -> ServiceLoader.load(SerializerRegister.class, this.getClass().getClassLoader()).iterator()).spliterator(), false).forEach(serializerRegister -> {
            LOGGER.debug("Registering serializer {}", serializerRegister);
            serializerRegister.registerSerializers(kryo);
        });
    }

    protected boolean shouldAddMuleSerializers() {
        return true;
    }
}

