/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.scheduler;

import com.mulesoft.anypoint.backoff.scheduler.configuration.FastRecoveryConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.observer.FastRecoveryObserver;
import com.mulesoft.anypoint.backoff.scheduler.observer.ReschedulingObserver;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.scheduler.runnable.FastRecovery;
import com.mulesoft.anypoint.backoff.scheduler.runnable.Reschedulable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Disposable;

public class BackoffScheduler
implements FastRecoveryObserver,
ReschedulingObserver,
Disposable {
    private final ScheduledExecutorService executorService;

    public BackoffScheduler(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public void schedule(BackoffRunnable runnable, SchedulingConfiguration configuration, FastRecoveryObserver ... recoveryObservers) {
        this.executorService.schedule(this.fastRecovery(runnable, configuration, recoveryObservers), configuration.delay().inMillis(), TimeUnit.MILLISECONDS);
    }

    public void scheduleWithFixedDelay(BackoffRunnable runnable, SchedulingConfiguration configuration) {
        this.executorService.schedule(new Reschedulable(runnable, configuration, this), configuration.delay().inMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public FastRecoveryObserver fastRecoveryUnstable(BackoffRunnable runnable, FastRecoveryConfiguration configuration) {
        this.executorService.schedule(new FastRecovery(runnable, configuration), configuration.delay().inMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public FastRecoveryObserver fastRecoveryStable(BackoffRunnable runnable, FastRecoveryConfiguration configuration) {
        return this;
    }

    @Override
    public FastRecoveryObserver fastRecoveryAbort(BackoffRunnable runnable) {
        return this;
    }

    @Override
    public ReschedulingObserver reschedule(BackoffRunnable runnable, SchedulingConfiguration configuration) {
        this.scheduleWithFixedDelay(runnable, configuration);
        return this;
    }

    public void dispose() {
        this.executorService.shutdownNow();
    }

    private FastRecovery fastRecovery(BackoffRunnable runnable, SchedulingConfiguration schedulingConfiguration, FastRecoveryObserver ... recoveryObservers) {
        return new FastRecovery(runnable, this.configuration(schedulingConfiguration, recoveryObservers));
    }

    private FastRecoveryConfiguration configuration(SchedulingConfiguration configuration, FastRecoveryObserver ... recoveryObservers) {
        ArrayList<FastRecoveryObserver> allObservers = new ArrayList<FastRecoveryObserver>(Arrays.asList(recoveryObservers));
        allObservers.add(this);
        return new FastRecoveryConfiguration(configuration, allObservers);
    }
}

