/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.LazyPage;
import com.mulesoft.connectivity.linkweave.api.interpreter.LazyResultError;
import com.mulesoft.connectivity.linkweave.api.interpreter.LazyTriggerPage;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.EagerPage;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import com.mulesoft.connectivity.linkweave.api.model.Page;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionValidationResult;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProvidedValue;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextData;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerItem;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage;
import com.mulesoft.connectivity.linkweave.api.util.SerializationUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.TypeType;

public class ModelInterpreter {
    private final DataWeaveScriptingEngine dataWeaveEngine;
    private final ModelInterpreterConfig config;
    private final SerializationUtil serializationUtil;
    private static final Function<Content, ? extends Page<ProvidedValue>> VALUE_PROVIDER_TO_PAGE = EagerPage.factory().getBuilderFunction(false, ProvidedValue::fromData).compose(Content::get);
    private static final Function<Content, ? extends Page<ProvidedValue>> VALUE_PROVIDER_TO_PAGE_PAGINATED = EagerPage.factory().getBuilderFunction(true, ProvidedValue::fromData).compose(Content::get);

    public ModelInterpreter(DataWeaveScriptingEngine dataWeaveEngine) {
        this(dataWeaveEngine, new ModelInterpreterConfig.Builder().build());
    }

    public ModelInterpreter(DataWeaveScriptingEngine engine, ModelInterpreterConfig config) {
        this.dataWeaveEngine = engine;
        this.config = config;
        this.serializationUtil = new SerializationUtil(engine, config);
    }

    public SerializationUtil getSerializationUtil() {
        return this.serializationUtil;
    }

    public ConnectionValidationResult testConnection(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo) {
        return this.executeTestConnection(null, connectionProviderModel, connectionInfo);
    }

    public ConnectionValidationResult testConnection(@Nullable TestConnectionModel testConnectionModel, BaseConnectionProviderModel connectionProviderModel, Object connectionInfo) {
        return this.executeTestConnection(testConnectionModel, connectionProviderModel, connectionInfo);
    }

    private ConnectionValidationResult executeTestConnection(@Nullable TestConnectionModel testConnectionModel, BaseConnectionProviderModel connectionProviderModel, Object connectionInfo) {
        if (testConnectionModel == null) {
            testConnectionModel = connectionProviderModel.getTestConnection();
        }
        if (testConnectionModel == null) {
            throw new IllegalStateException(String.format("No 'validate' function found in %s to run a test connection", ModelInterpreter.getModelReference(connectionProviderModel)));
        }
        DataWeaveCall call = this.call();
        try {
            ConnectionValidationResult connectionValidationResult;
            Map result = (Map)call.bind("connection", connectionProviderModel).bind("info", connectionInfo).bind("testConnection", testConnectionModel).write("testConnection.validate(connection.connect(info))");
            boolean isValid = (Boolean)Objects.requireNonNull(result.get("isValid"), "'validate' function did not specify if the connection is valid");
            ConnectionValidationResult connectionValidationResult2 = connectionValidationResult = isValid ? ConnectionValidationResult.success() : ConnectionValidationResult.failure((String)result.get("message"), (String)result.get("error"));
            if (call != null) {
                call.close();
            }
            return connectionValidationResult;
        }
        catch (Throwable throwable) {
            try {
                if (call != null) {
                    try {
                        call.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error generating connection result for " + ModelInterpreter.getModelReference(connectionProviderModel), e);
            }
        }
    }

    @Deprecated(since="1.4.0")
    public List<Map<?, ?>> executeResolveConnectionExtensions(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo) {
        return this.executeResolveConnectionExtensions(Connection.of(connectionProviderModel, connectionInfo));
    }

    public List<Map<?, ?>> executeResolveConnectionExtensions(Connection<?> connection) {
        try (DataWeaveCall call = this.call();){
            List list = (List)call.bind("provider", connection.getProvider()).bind("info", connection.getInfo()).write("provider.extensions(info)");
            return list;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<Object> executeOperation(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> operationModel, Object parameters) {
        return this.executeOperation(Connection.of(connectionProviderModel, connectionInfo), operationModel, parameters).map(v -> {
            if (v instanceof Page) {
                return v;
            }
            if (v instanceof Content) {
                Content content;
                try (Content content2 = content = (Content)v;){
                    Object object = content.get();
                    return object;
                }
            }
            throw new IllegalStateException(String.format("Expected a Page or a Content, got %s", v.getClass()));
        });
    }

    public OperationResult<? extends AutoCloseable> executeOperation(Connection<?> connection, BaseExecutableComponentModel<?> operationModel, Object parameters) {
        String scriptText = "com::mulesoft::connectivity::Runtime::executeOperation(operation, parameters, connection)";
        try (DataWeaveCall call = this.call();){
            DataWeaveLiveValue result = call.bind("connection", connection).bind("operation", operationModel).bind("parameters", parameters).execute(scriptText);
            OperationResult<Content> res = ModelInterpreter.intoOperationResult(result);
            OperationResult<Content> operationResult = operationModel.isPaginated() ? res.map(data -> new LazyPage(ModelInterpreter.resolveValue(result))) : res;
            return operationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<Page<Object>> executeOperationNextPage(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> operationModel, Object nextPageData) {
        return this.executeOperationNextPage(Connection.of(connectionProviderModel, connectionInfo), operationModel, nextPageData);
    }

    public OperationResult<Page<Object>> executeOperationNextPage(Connection<?> connection, BaseExecutableComponentModel<?> operationModel, Object nextPageData) {
        if (!operationModel.isPaginated()) {
            throw new IllegalArgumentException("Operation " + operationModel.getModelReference().orElseGet(operationModel::getName) + " is not paginated");
        }
        Object parameters = ((Map)nextPageData).get("args");
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::executePaginatedOperationNextPage(operation, parameters, connection)";
            DataWeaveLiveValue result = call.bind("connection", connection).bind("operation", operationModel).bind("parameters", parameters).execute(scriptText);
            OperationResult<Page<Object>> operationResult = ModelInterpreter.intoOperationResult(result).map(data -> new LazyPage(ModelInterpreter.resolveValue(result)));
            return operationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<TriggerPage<? extends TriggerItem>> executeTrigger(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> triggerModel, Object watermark, Object parameters) {
        return this.executeTrigger(Connection.of(connectionProviderModel, connectionInfo), triggerModel, watermark, parameters);
    }

    public OperationResult<TriggerPage<? extends TriggerItem>> executeTrigger(Connection<?> connection, BaseExecutableComponentModel<?> triggerModel, Object watermark, Object parameters) {
        Objects.requireNonNull(watermark);
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::serializeTriggerResponseIfSuccess(\n  com::mulesoft::connectivity::Runtime::executeTrigger(\n    trigger,\n    com::mulesoft::connectivity::Runtime::deserializeObject(watermark),\n    parameters,\n    connection))";
            DataWeaveLiveValue result = call.bind("connection", connection).bind("trigger", triggerModel).bind("watermark", watermark).bind("parameters", parameters).execute(scriptText);
            OperationResult<TriggerPage<? extends TriggerItem>> operationResult = ModelInterpreter.intoOperationResult(result).map(data -> new LazyTriggerPage(ModelInterpreter.resolveValue(result)));
            return operationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<? extends TriggerPage<? extends TriggerItem>> executeTriggerNextPage(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> triggerModel, NextData nextData) {
        return this.executeTriggerNextPage(Connection.of(connectionProviderModel, connectionInfo), triggerModel, nextData);
    }

    public OperationResult<? extends TriggerPage<? extends TriggerItem>> executeTriggerNextPage(Connection<?> connection, BaseExecutableComponentModel<?> triggerModel, NextData nextData) {
        Serializable latestWatermarkObject = nextData.getNextPoll().getLatestWatermark();
        Serializable greatestWatermarkObject = nextData.getNextPoll().getGreatestWatermark();
        Serializable nextPageObject = nextData.getNextPage().orElseThrow();
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::serializeTriggerResponseIfSuccess(\n  com::mulesoft::connectivity::Runtime::executeTriggerNextPage(\n    trigger,\n    com::mulesoft::connectivity::Runtime::deserializeObject(serializedWatermark),\n    com::mulesoft::connectivity::Runtime::deserializeObject(serializedPartialGreatestWatermark),\n    com::mulesoft::connectivity::Runtime::deserializeObject(serializedParameters).args,\n    connection))";
            DataWeaveLiveValue result = call.bind("connection", connection).bind("trigger", triggerModel).bind("serializedWatermark", latestWatermarkObject).bind("serializedPartialGreatestWatermark", greatestWatermarkObject).bind("serializedParameters", nextPageObject).execute(scriptText);
            OperationResult<LazyTriggerPage> operationResult = ModelInterpreter.intoOperationResult(result).map(data -> new LazyTriggerPage(ModelInterpreter.resolveValue(result)));
            return operationResult;
        }
    }

    public Integer executeTriggerCompareWatermark(BaseExecutableComponentModel<?> triggerModel, Object param1, Object param2) {
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::executeTriggerCompareWatermark(trigger, arg1, arg2)";
            Integer n = Integer.parseInt(call.bind("trigger", triggerModel).bind("arg1", param1).bind("arg2", param2).write(scriptText).toString());
            return n;
        }
    }

    @Deprecated(since="1.4.0")
    public Serializable getInitialWatermark(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> triggerModel, Object parameters) {
        return this.getInitialWatermark(Connection.of(connectionProviderModel, connectionInfo), triggerModel, parameters);
    }

    public Serializable getInitialWatermark(Connection<?> connection, BaseExecutableComponentModel<?> triggerModel, Object parameters) {
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::serializeObject(\n  com::mulesoft::connectivity::Runtime::getInitialWatermark(trigger, parameters, connection))";
            Serializable serializable = (Serializable)call.bind("connection", connection).bind("trigger", triggerModel).bind("parameters", parameters).write(scriptText);
            return serializable;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<Page<ProvidedValue>> executeValueProvider(ConnectionProviderModel connectionProviderModel, Object connectionInfo, ValueProviderModel valueProviderModel, Object parameters) {
        return this.executeValueProvider(Connection.of(connectionProviderModel, connectionInfo), valueProviderModel, parameters);
    }

    public OperationResult<Page<ProvidedValue>> executeValueProvider(Connection<?> connection, ValueProviderModel valueProviderModel, Object parameters) {
        try (DataWeaveCall call = this.call();){
            boolean isPaginated = valueProviderModel.isPaginated();
            String script = isPaginated ? "com::mulesoft::connectivity::Runtime::executePaginatedValueProvider(valueProvider, parameters, connection)" : "com::mulesoft::connectivity::Runtime::executeValueProvider(valueProvider, parameters, connection)";
            OperationResult<Page<ProvidedValue>> operationResult = ModelInterpreter.intoOperationResult(call.bind("connection", connection).bind("valueProvider", valueProviderModel).bind("parameters", parameters).execute(script)).map(isPaginated ? VALUE_PROVIDER_TO_PAGE_PAGINATED : VALUE_PROVIDER_TO_PAGE);
            return operationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<Page<ProvidedValue>> executeValueProviderNextPage(ConnectionProviderModel connectionProviderModel, Object connectionInfo, ValueProviderModel valueProviderModel, Object nextPageData) {
        return this.executeValueProviderNextPage(Connection.of(connectionProviderModel, connectionInfo), valueProviderModel, nextPageData);
    }

    public OperationResult<Page<ProvidedValue>> executeValueProviderNextPage(Connection<?> connection, ValueProviderModel valueProviderModel, Object nextPageData) {
        try (DataWeaveCall call = this.call();){
            Object parameters = ((Map)nextPageData).get("args");
            String scriptText = "com::mulesoft::connectivity::Runtime::executePaginatedValueProviderNextPage(valueProvider, parameters, connection)";
            OperationResult<Page<ProvidedValue>> operationResult = ModelInterpreter.intoOperationResult(call.bind("connection", connection).bind("valueProvider", valueProviderModel).bind("parameters", parameters).execute(scriptText)).map(VALUE_PROVIDER_TO_PAGE_PAGINATED);
            return operationResult;
        }
    }

    public OperationResult<DWType> executeMetadataProvider(ConnectionProviderModel connectionProviderModel, Object connectionInfo, MetadataProviderModel metadataProviderModel, Object parameters) {
        return this.executeMetadataProvider(Connection.of(connectionProviderModel, connectionInfo), metadataProviderModel, parameters);
    }

    public OperationResult<DWType> executeMetadataProvider(Connection<?> connection, MetadataProviderModel metadataProviderModel, Object parameters) {
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::executeMetadataProvider(metadataProvider, parameters, connection)";
            OperationResult<DWType> operationResult = ModelInterpreter.intoOperationResult(call.bind("connection", connection).bind("metadataProvider", metadataProviderModel).bind("parameters", parameters).execute(scriptText)).map(o -> TypeUtils.resolveWeaveType(extendedType -> ((TypeType)this.dataWeaveEngine.inferTypeOf(extendedType).get()).getType(), (Map)o.get()));
            return operationResult;
        }
    }

    private static DataWeaveLiveValue resolveValue(DataWeaveLiveValue result) {
        DataWeaveLiveValue value = result.execute("result.value");
        result.close();
        return value;
    }

    static String getModelReference(Model model) {
        return model.getModelReference().filter(Predicate.not(String::isEmpty)).orElseThrow(() -> new IllegalStateException("Model must have a valid selector set as model reference"));
    }

    private static OperationResult<Content> intoOperationResult(DataWeaveLiveValue liveValue) {
        Object isSuccess = liveValue.run("result.success");
        if (isSuccess instanceof Boolean && ((Boolean)isSuccess).booleanValue()) {
            return OperationResult.success(new Content(liveValue.execute("result.value")));
        }
        return OperationResult.failure(new LazyResultError(liveValue));
    }

    DataWeaveCall call() {
        return new DataWeaveCall(this.config, this.dataWeaveEngine, this::call);
    }
}

