/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.lock;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.map.IMap;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterQuorumException;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterRuntimeException;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastTimeoutUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastLock
implements Lock {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastLock.class);
    private static final String EXCEPTION_MESSAGE_FORMAT = "Error while trying to lock with lockId='%s'";
    private static final String WAIT_FOR_QUORUM_PROPERTY_NAME = "mule.cluster.lock.wait.quorum";
    private final IMap locksMap;
    private final String lockId;
    private final boolean waitForQuorumOnLock;

    public HazelcastLock(IMap locksMap, String lockId) {
        this.locksMap = locksMap;
        this.lockId = lockId;
        this.waitForQuorumOnLock = Boolean.getBoolean(WAIT_FOR_QUORUM_PROPERTY_NAME);
    }

    @Override
    public void lock() {
        if (this.waitForQuorumOnLock) {
            this.lockWaitingQuorum();
        } else {
            this.lockAndWrapException();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        boolean isAcquired = false;
        while (!isAcquired) {
            try {
                this.locksMap.lock((Object)this.lockId);
                isAcquired = true;
            }
            catch (HazelcastException qe) {
                Thread.sleep(500L);
            }
        }
    }

    @Override
    public boolean tryLock() {
        try {
            return this.locksMap.tryLock((Object)this.lockId);
        }
        catch (HazelcastException e) {
            LOGGER.warn(String.format(EXCEPTION_MESSAGE_FORMAT, this.lockId), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        try {
            return HazelcastTimeoutUtils.executeWithTimeoutIntervals(unit.toMillis(time), timeout -> this.doTryLock((long)timeout, TimeUnit.MILLISECONDS), result -> result);
        }
        catch (HazelcastException e) {
            LOGGER.warn(EXCEPTION_MESSAGE_FORMAT, (Object)this.lockId, (Object)e);
            return false;
        }
    }

    private boolean doTryLock(long time, TimeUnit unit) throws InterruptedException {
        try {
            return this.locksMap.tryLock((Object)this.lockId, time, unit);
        }
        catch (HazelcastException e) {
            LOGGER.debug(EXCEPTION_MESSAGE_FORMAT, (Object)this.lockId, (Object)e);
            return false;
        }
    }

    @Override
    public void unlock() {
        try {
            this.locksMap.unlock((Object)this.lockId);
        }
        catch (HazelcastInstanceNotActiveException e) {
            LOGGER.warn("Unlocking lock with id '{}' when the hazelcast instance is inactive", (Object)this.lockId, (Object)e);
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("newCondition() not supported in HazelcastLock");
    }

    private void lockAndWrapException() {
        try {
            this.locksMap.lock((Object)this.lockId);
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException(String.format(EXCEPTION_MESSAGE_FORMAT, this.lockId), qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException(String.format(EXCEPTION_MESSAGE_FORMAT, this.lockId), he);
        }
    }

    private void lockWaitingQuorum() {
        boolean isAcquired = false;
        while (!isAcquired) {
            try {
                this.locksMap.lock((Object)this.lockId);
                isAcquired = true;
            }
            catch (HazelcastException qe) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

