/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.journal.TransactionLogAppender;
import bitronix.tm.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskForceWaitQueue {
    private static final Logger log = LoggerFactory.getLogger(DiskForceWaitQueue.class);
    private final List<TransactionLogAppender> objects = new ArrayList<TransactionLogAppender>();
    private boolean isCleared = false;

    public synchronized boolean enqueue(TransactionLogAppender tla) {
        if (this.isCleared) {
            return false;
        }
        this.objects.add(tla);
        if (log.isDebugEnabled()) {
            log.debug("enqueued " + String.valueOf(tla) + ", " + this.objects.size() + " TransactionLogAppender waiting for a disk force in " + String.valueOf(this));
        }
        this.notifyAll();
        return true;
    }

    public synchronized TransactionLogAppender head() {
        if (log.isDebugEnabled()) {
            log.debug("returning head TransactionLogAppender");
        }
        return this.objects.get(0);
    }

    public synchronized void clear() {
        if (log.isDebugEnabled()) {
            log.debug("clearing list of " + this.objects.size() + " waiting TransactionLogAppender(s) in " + String.valueOf(this));
        }
        this.objects.clear();
        this.isCleared = true;
        this.notifyAll();
    }

    public synchronized boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public synchronized void waitUntilNotEmpty() throws InterruptedException {
        while (this.objects.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("waiting for some TransactionLogAppender to get enqueued");
            }
            this.wait();
        }
    }

    public synchronized int size() {
        return this.objects.size();
    }

    public synchronized void waitUntilNotContains(TransactionLogAppender tla) throws InterruptedException {
        while (CollectionUtils.containsByIdentity(this.objects, tla)) {
            if (log.isDebugEnabled()) {
                log.debug("waiting for " + String.valueOf(tla) + " to get dequeued");
            }
            this.wait();
        }
    }
}

