/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.hdp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiRecordDto {
    private ApiKey apiKey;
    private String serviceName;

    public ApiRecordDto(@JsonProperty(value="apiId", required=true) long id, @JsonProperty(value="serviceName", required=true) String serviceName) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new IllegalArgumentException("Undefined serviceName for apiId " + id);
        }
        this.apiKey = new ApiKey(Long.valueOf(id));
        this.serviceName = serviceName;
    }

    @JsonIgnore
    public ApiKey getApiKey() {
        return this.apiKey;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRecordDto that = (ApiRecordDto)o;
        return Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.serviceName, that.serviceName);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.serviceName);
    }

    public String toString() {
        return "ApiRecordDto{apiKey=" + String.valueOf(this.apiKey) + ", serviceName='" + this.serviceName + "'}";
    }
}

