/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.contracts;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.model.contracts.HashedClient;
import com.mulesoft.mule.runtime.gw.model.contracts.HashedClientFactory;

public class ClientAuthenticator {
    public boolean authenticate(Client memoryClient, Client inboundClient) {
        if (memoryClient.getClass().equals(inboundClient.getClass())) {
            return memoryClient.equals((Object)inboundClient);
        }
        if (inboundClient instanceof HashedClient) {
            return this.matchesHashedClientCredentials(inboundClient, memoryClient.id(), memoryClient.secret());
        }
        return this.authenticate(memoryClient, inboundClient.id(), inboundClient.secret());
    }

    public boolean authenticate(Client memoryClient, String id, String secret) {
        if (secret == null) {
            return false;
        }
        if (memoryClient instanceof HashedClient) {
            return this.matchesHashedClientCredentials(memoryClient, id, secret);
        }
        return memoryClient.secret().equals(secret);
    }

    private boolean matchesHashedClientCredentials(Client client, String clientId, String clientSecret) {
        HashedClient hashedClient = (HashedClient)client;
        return hashedClient.equals(this.getHashedClient(clientId, clientSecret, hashedClient.algorithm()));
    }

    private Client getHashedClient(String clientId, String clientSecret, String algorithm) {
        return new HashedClientFactory(algorithm).create(clientId, clientSecret, null);
    }
}

