/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies;

import com.mulesoft.mule.runtime.gw.api.construction.Builder;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PolicyDefinitionBuilder
implements Builder<PolicyDefinition> {
    private final PolicyDefinition baseDefinition;
    private int order;
    private List<ApiKey> apiKey;
    private PolicyConfiguration configuration;
    private static final String IDENTITY_MANAGEMENT_TOKEN_URL = "identityManagementTokenUrl";
    private static final String IDENTITY_MANAGEMENT_CLIENT_ID = "identityManagementClientId";
    private static final String IDENTITY_MANAGEMENT_CLIENT_SECRET = "identityManagementClientSecret";

    public static boolean hasIdentityManagementProperties(PolicyDefinition policyDefinition) {
        Map configuration = policyDefinition.getConfigurationData().getConfiguration();
        return configuration.get(IDENTITY_MANAGEMENT_TOKEN_URL) != null || configuration.get(IDENTITY_MANAGEMENT_CLIENT_ID) != null || configuration.get(IDENTITY_MANAGEMENT_CLIENT_SECRET) != null;
    }

    public PolicyDefinitionBuilder(PolicyDefinition baseDefinition) {
        this.baseDefinition = baseDefinition;
        this.order = baseDefinition.getOrder();
        this.apiKey = baseDefinition.getApiKeys();
        this.configuration = baseDefinition.getConfigurationData();
    }

    public PolicyDefinitionBuilder order(int order) {
        this.order = order;
        return this;
    }

    public PolicyDefinitionBuilder apiKey(ApiKey apiKey) {
        this.apiKey = Collections.singletonList(apiKey);
        return this;
    }

    public PolicyDefinitionBuilder noIdentityManagement() {
        this.configuration = new PolicyConfiguration(this.configuration.getConfiguration().entrySet().stream().filter(entry -> !this.isIdentityProperty((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return this;
    }

    private boolean isIdentityProperty(String key) {
        return key.equals(IDENTITY_MANAGEMENT_TOKEN_URL) || key.equals(IDENTITY_MANAGEMENT_CLIENT_ID) || key.equals(IDENTITY_MANAGEMENT_CLIENT_SECRET);
    }

    public PolicyDefinition build() {
        if (this.baseDefinition instanceof OfflinePolicyDefinition) {
            return new OfflinePolicyDefinition(this.baseDefinition.getId(), this.baseDefinition.getTemplateKey(), this.apiKey, (List<HttpResourcePointcut>)this.baseDefinition.getHttpResourcePointcuts(), this.order, this.configuration);
        }
        return new PolicyDefinition(this.baseDefinition.getId(), this.baseDefinition.getVersion(), this.baseDefinition.getTemplateKey(), this.apiKey, this.baseDefinition.getHttpResourcePointcuts(), this.order, this.configuration);
    }
}

