/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.FlowInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.processor.interceptor.ComponentInterceptorAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ComponentInterceptorFactoryAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptionAction;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class ReactiveAroundInterceptorAdapter
extends ReactiveInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveAroundInterceptorAdapter.class);

    public ReactiveAroundInterceptorAdapter(ProcessorInterceptorFactory interceptorFactory) {
        super(interceptorFactory);
    }

    public ReactiveAroundInterceptorAdapter(FlowInterceptorFactory interceptorFactory) {
        super(interceptorFactory);
    }

    public ReactiveAroundInterceptorAdapter(ComponentInterceptorFactoryAdapter interceptorFactoryAdapter) {
        super(interceptorFactoryAdapter);
    }

    @Override
    protected ReactiveProcessor doApply(ReactiveProcessor component, ReactiveProcessor next, ComponentLocation componentLocation, ComponentInterceptorAdapter interceptor, Map<String, String> dslParameters) {
        if (interceptor.implementsAround()) {
            LOGGER.debug("Configuring interceptor '{}' around processor '{}'...", (Object)interceptor, (Object)componentLocation.getLocation());
            return publisher -> Flux.deferContextual(ctx -> Flux.from((Publisher)publisher).cast(InternalEvent.class).flatMap(event -> Mono.fromFuture(this.doAround((InternalEvent)event, interceptor, component, dslParameters, next, (ContextView)ctx)).onErrorMap(CompletionException.class, Throwable::getCause)));
        }
        return next;
    }

    private CompletableFuture<InternalEvent> doAround(InternalEvent event, ComponentInterceptorAdapter interceptor, ReactiveProcessor component, Map<String, String> dslParameters, ReactiveProcessor next, ContextView ctx) {
        InternalEvent eventWithResolvedParams = this.addResolvedParameters(event, (Component)component, dslParameters);
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
        ReactiveInterceptionAction reactiveInterceptionAction = new ReactiveInterceptionAction(interceptionEvent, next, ctx, component, this.errorTypeLocator);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Calling around() for '{}' in processor '{}'...", (Object)interceptor, (Object)((Component)component).getLocation().getLocation());
        }
        try {
            return ((CompletableFuture)ClassUtils.withContextClassLoader(interceptor.getClassLoader(), () -> interceptor.around(((Component)component).getLocation(), this.getResolvedParams(eventWithResolvedParams), interceptionEvent, reactiveInterceptionAction)).exceptionally(t -> {
                if (t instanceof MessagingException) {
                    throw new CompletionException((Throwable)t);
                }
                throw new CompletionException((Throwable)((Object)this.resolveMessagingException(eventWithResolvedParams, t instanceof CompletionException ? t.getCause() : t, (Component)component, Optional.empty())));
            })).thenApply(interceptedEvent -> interceptedEvent != null ? ((DefaultInterceptionEvent)interceptedEvent).resolve() : null);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)((Object)this.resolveMessagingException(interceptionEvent.resolve(), e, (Component)component, Optional.empty())));
        }
    }
}

