/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.model.Page;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public class EagerPage<T>
implements Page<T> {
    private static final long serialVersionUID = 1L;
    private final List<T> items;
    private final @Nullable Serializable nextPage;

    public EagerPage(List<T> items, @Nullable Serializable nextPage) {
        this.items = List.copyOf(items);
        this.nextPage = nextPage;
    }

    @Override
    public List<T> getItems() {
        return this.items;
    }

    @Override
    public Optional<Serializable> getNextPage() {
        return Optional.ofNullable(this.nextPage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("Page{items=").append(this.items);
        if (this.nextPage != null) {
            sb.append(", nextPage=").append(this.nextPage);
        }
        return sb.append('}').toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EagerPage)) {
            return false;
        }
        EagerPage page = (EagerPage)o;
        return Objects.equals(this.items, page.items) && Objects.equals(this.nextPage, page.nextPage);
    }

    public static <I> PageFactory<I> factory() {
        return new PageFactory();
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPage);
    }

    @Override
    public void close() throws Exception {
    }

    public static class PageFactory<I>
    extends AbstractPageFactory<EagerPage<I>, I> {
        @Override
        public EagerPage<I> fromNotPaginatedData(Object data, Function<Object, ? extends I> buildItem) {
            return new EagerPage<I>(PageFactory.mapList((List)data, buildItem), null);
        }

        @Override
        public EagerPage<I> fromPaginatedData(Object data, Function<Object, ? extends I> buildItem) {
            Map pageMap = (Map)data;
            return new EagerPage<I>(super.getItems(buildItem, pageMap), (Serializable)pageMap.get("nextPage"));
        }
    }

    protected static abstract class AbstractPageFactory<P extends EagerPage<I>, I> {
        protected AbstractPageFactory() {
        }

        public Function<Object, P> getBuilderFunction(boolean paginated, Function<Object, ? extends I> buildItem) {
            return paginated ? data -> this.fromPaginatedData(data, buildItem) : data -> this.fromNotPaginatedData(data, buildItem);
        }

        public abstract P fromNotPaginatedData(Object var1, Function<Object, ? extends I> var2);

        public abstract P fromPaginatedData(Object var1, Function<Object, ? extends I> var2);

        protected static <P, Q> List<Q> mapList(List<P> l, Function<? super P, ? extends Q> buildItem) {
            return l.stream().map(buildItem).toList();
        }

        protected List<I> getItems(Function<Object, ? extends I> buildItem, Map<?, ?> pageMap) {
            return AbstractPageFactory.mapList((List)pageMap.get("items"), buildItem);
        }
    }
}

