/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.mulesoft.mule.runtime.module.serialization.kryo.internal.ExternalKryoInstanceFactory;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.InternalKryoInstanceFactory;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.compression.KryoCompressionMode;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.protocol.KryoSerializationProtocol;
import jakarta.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

public class KryoObjectSerializer
extends AbstractComponent
implements ObjectSerializer,
Initialisable {
    private final KryoCompressionMode compressionMode;
    private volatile KryoSerializationProtocol externalKryoSerializationProtocol;
    private volatile KryoSerializationProtocol internalKryoSerializationProtocol;
    private ClassLoaderRepository classLoaderRepository;
    private MuleContext muleContext;

    public KryoObjectSerializer() {
        this(KryoCompressionMode.NONE);
    }

    public KryoObjectSerializer(KryoCompressionMode compressionMode) {
        this.compressionMode = compressionMode;
    }

    public SerializationProtocol getInternalProtocol() {
        return this.internalKryoSerializationProtocol;
    }

    public SerializationProtocol getExternalProtocol() {
        return this.externalKryoSerializationProtocol;
    }

    public void initialise() throws InitialisationException {
        try {
            this.externalKryoSerializationProtocol = new KryoSerializationProtocol(new ExternalKryoInstanceFactory(), this.compressionMode, this.classLoaderRepository, this.muleContext.getExecutionClassLoader());
            this.internalKryoSerializationProtocol = new KryoSerializationProtocol(new InternalKryoInstanceFactory(), this.compressionMode, this.classLoaderRepository, this.muleContext.getExecutionClassLoader());
        }
        catch (IllegalDependencyInjectionException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.externalKryoSerializationProtocol.initialise();
        this.internalKryoSerializationProtocol.initialise();
    }

    @Inject
    public void setClassLoaderRepository(ClassLoaderRepository classLoaderRepository) {
        this.classLoaderRepository = classLoaderRepository;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

