/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.internal.lang3.Validate;
import java.io.IOException;
import java.util.Objects;

public enum ConditionalHelpers implements Helper<Object>
{
    eq{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            Object b = options.param(0, null);
            boolean result = this.eq(a, b);
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    neq{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            Object b = options.param(0, null);
            boolean bl = result = !this.eq(a, b);
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    gt{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options.param(0, null)) > 0;
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    gte{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options.param(0, null)) >= 0;
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    lt{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options.param(0, null)) < 0;
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    lte{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options.param(0, null)) <= 0;
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    and{

        @Override
        public Object apply(Object context, Options options) throws IOException {
            boolean result;
            boolean bl = result = !Handlebars.Utils.isEmpty(context);
            if (result) {
                for (int i = 0; i < options.params.length && result; ++i) {
                    result = !Handlebars.Utils.isEmpty(options.params[i]);
                }
            }
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    or{

        @Override
        public Object apply(Object context, Options options) throws IOException {
            boolean result;
            boolean bl = result = !Handlebars.Utils.isEmpty(context);
            if (!result) {
                int i = 0;
                while (!result && i < options.params.length) {
                    result = !Handlebars.Utils.isEmpty(options.params[i++]);
                }
            }
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    not{

        @Override
        public Object apply(Object context, Options options) throws IOException {
            boolean result = Handlebars.Utils.isEmpty(context);
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    };


    protected int cmp(Object a, Object b) {
        try {
            Validate.isTrue(a instanceof Comparable, "Not a comparable: " + a, new Object[0]);
            Validate.isTrue(b instanceof Comparable, "Not a comparable: " + b, new Object[0]);
            return ((Comparable)a).compareTo(b);
        }
        catch (ClassCastException x) {
            return Double.compare(this.toDoubleOrError(a, x), this.toDoubleOrError(b, x));
        }
    }

    protected boolean eq(Object a, Object b) {
        boolean value = Objects.equals(a, b);
        if (!value && a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() == ((Number)b).doubleValue();
        }
        return value;
    }

    private double toDoubleOrError(Object value, RuntimeException x) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw x;
    }
}

