/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.contracts.repository;

import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactContractsRepository
implements ContractRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompactContractsRepository.class);
    private final ContractRepository decoratee;
    private final Set<ApiKey> compacted;

    public CompactContractsRepository(ContractRepository decoratee) {
        this.decoratee = decoratee;
        this.compacted = new HashSet<ApiKey>();
    }

    @Override
    public void store(ApiKey apiKey, Collection<Contract> contracts) {
        this.decoratee.store(apiKey, contracts);
        if (!this.compacted.contains(apiKey)) {
            this.compact();
            this.compacted.add(apiKey);
        }
    }

    @Override
    public void storeSlas(ApiKey apiKey, Collection<Sla> slas) {
        this.decoratee.storeSlas(apiKey, slas);
    }

    @Override
    public Set<Contract> load(ApiKey apiKey) {
        return this.decoratee.load(apiKey);
    }

    @Override
    public void delete(ApiKey apiKey) {
        this.decoratee.delete(apiKey);
    }

    @Override
    public boolean contains(ApiKey apiKey) {
        return this.decoratee.contains(apiKey);
    }

    @Override
    public boolean containsSla(ApiKey apiKey) {
        return this.decoratee.containsSla(apiKey);
    }

    @Override
    public void compact() {
        this.decoratee.compact();
    }

    public void dispose() {
        this.decoratee.dispose();
    }
}

