/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal;

import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.extension.record.AcceptRecordPolicy;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstanceStatus;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepResult;
import com.mulesoft.mule.runtime.module.batch.api.notification.BatchNotification;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.exception.BatchException;
import com.mulesoft.mule.runtime.module.batch.exception.ExceptionHistory;
import com.mulesoft.mule.runtime.module.batch.internal.BaseBatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.internal.DefaultBatchStepAggregator;
import com.mulesoft.mule.runtime.module.batch.internal.engine.BatchProcessingTemplate;
import com.mulesoft.mule.runtime.module.batch.internal.engine.RecordCompletableFuture;
import com.mulesoft.mule.runtime.module.batch.internal.record.RecordFilteringStrategy;
import com.mulesoft.mule.runtime.module.batch.reporting.StepExceptionReporter;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.runtime.tracer.api.context.getter.MapDistributedTraceContextGetter;
import org.mule.runtime.tracer.customization.api.InitialSpanInfoProvider;
import org.mule.runtime.tracer.impl.span.InternalSpan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBatchStep
extends AbstractMessageProcessorOwner
implements BatchStepAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBatchStep.class);
    public static final String BATCH_STEP_SPAN_NAME = "batch-step";
    public static final String BATCH_STEP_RECORD_SPAN_NAME = "batch-step-record";
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private ConfigurationComponentLocator locator;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    @Inject
    private InternalProfilingService internalProfilingService;
    @Inject
    private ComponentTracerFactory componentTracerFactory;
    @Inject
    private InitialSpanInfoProvider initialSpanInfoProvider;
    private String name;
    private DefaultBatchStepAggregator batchStepAggregator;
    private AcceptRecordPolicy acceptPolicy = AcceptRecordPolicy.NO_FAILURES;
    private String acceptExpression;
    private BatchStep nextStep;
    private BatchProcessingTemplate processingTemplate;
    private MessageProcessorChain messageProcessorChain;
    private RecordFilteringStrategy recordFilteringStrategy;
    private BatchEngine batchEngine;
    private StepExceptionReporter exceptionReporter = new StepExceptionReporter(this, LOGGER);
    private boolean last = false;
    private BatchJobAdapter job;
    private List<Processor> messageProcessors = Collections.emptyList();
    private Map<String, String> serializedBatchStepSpan = Collections.emptyMap();
    private EventTracer<CoreEvent> coreEventTracer;
    private Span stepSpan;
    private final Boolean lock = false;
    private String processingBatchJobInstanceId = null;

    public void initialise() throws InitialisationException {
        try {
            this.coreEventTracer = this.internalProfilingService.getCoreEventTracer();
            this.messageProcessorChain = MessageProcessors.newChain((Optional)MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.locator, (Component)this), this.messageProcessors, (String)this.getLocation().getLocation(), (ComponentTracer)this.componentTracerFactory.fromComponent((Component)this, BATCH_STEP_RECORD_SPAN_NAME, ""));
            super.initialise();
            LifecycleUtils.initialiseIfNeeded((Object)this.expressionManager);
            this.recordFilteringStrategy = this.createFilteringStrategy();
            this.initStepAggregator();
            this.batchEngine.addBatchProcessingListener(this.job, new BaseBatchProcessingListener(){

                @Override
                public void onJobStopped(BatchJobInstanceAdapter jobInstance) {
                    DefaultBatchStep.this.releaseResources(jobInstance);
                }

                @Override
                public void onJobFinished(BatchJobInstanceAdapter jobInstance) {
                    DefaultBatchStep.this.exceptionReporter.reset(jobInstance);
                }
            });
            this.processingTemplate = this.createProcessingTemplate();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private BatchProcessingTemplate createProcessingTemplate() {
        final FlowTraceManager flowTraceManager = this.muleContext.getFlowTraceManager();
        return new BatchProcessingTemplate((ReactiveProcessor)this.messageProcessorChain, this.getLocation(), flowTraceManager, this.muleContext.getStreamCloserService()){

            @Override
            protected void before(BatchJobInstanceAdapter jobInstance, CoreEvent event) throws MuleException {
                super.before(jobInstance, event);
                flowTraceManager.onFlowStart(EnrichedNotificationInfo.createInfo((Event)event, null, null), DefaultBatchStep.this.getName());
            }

            @Override
            protected void onSuccess(BatchJobInstanceAdapter jobInstance, CoreEvent responseEvent) throws MuleException {
                BatchUtils.getRecord(responseEvent).updateWith(responseEvent);
            }

            @Override
            protected void onException(BatchJobInstanceAdapter jobInstance, Exception e, CoreEvent event) throws MuleException {
                DefaultBatchStep.this.exceptionReporter.report(jobInstance, e);
                Record record = BatchUtils.getRecord(event);
                record.updateWith(event);
                BatchException batchException = BatchUtils.toBatchException(e, jobInstance);
                DefaultBatchStep.this.notificationDispatcher.dispatch((Notification)new BatchNotification(jobInstance, DefaultBatchStep.this, record, (Exception)((Object)batchException), BatchNotification.STEP_RECORD_FAILED));
                throw batchException;
            }

            @Override
            protected void onFinally(BatchJobInstanceAdapter jobInstance, CoreEvent originalEvent, CoreEvent resultEvent) throws MuleException {
                super.onFinally(jobInstance, originalEvent, resultEvent);
                flowTraceManager.onFlowComplete(EnrichedNotificationInfo.createInfo((Event)originalEvent, null, null));
            }
        };
    }

    private void initStepAggregator() throws InitialisationException {
        if (this.batchStepAggregator != null) {
            this.batchStepAggregator.setMuleContext(this.muleContext);
            this.batchStepAggregator.setStep(this);
            this.batchStepAggregator.setBatchEngine(this.batchEngine);
            this.batchStepAggregator.setExceptionReporter(this.exceptionReporter);
            this.batchStepAggregator.initialise();
        }
    }

    @Override
    public synchronized void releaseResources(BatchJobInstanceAdapter jobInstance) {
        if (this.batchStepAggregator != null) {
            this.batchStepAggregator.releaseResources(jobInstance);
        }
        this.exceptionReporter.reset(jobInstance);
    }

    private RecordFilteringStrategy createFilteringStrategy() {
        return new RecordFilteringStrategy(this.acceptPolicy, this.acceptExpression, this.expressionManager);
    }

    public void start() throws MuleException {
        if (this.getOwnedObjects() != null) {
            super.start();
        }
        if (this.batchStepAggregator != null) {
            this.batchStepAggregator.start();
        }
    }

    public void stop() throws MuleException {
        super.stop();
        if (this.batchStepAggregator != null) {
            this.batchStepAggregator.stop();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.batchStepAggregator != null) {
            this.batchStepAggregator.dispose();
        }
    }

    @Override
    public Record onRecord(Record record, BatchTransactionContext ctx) throws MuleException {
        block5: {
            BatchJobInstanceAdapter jobInstance = ctx.getJobInstance();
            try {
                if (this.processRecord(record, jobInstance, ctx) != null && this.batchStepAggregator != null) {
                    try {
                        this.batchStepAggregator.add(record, ctx);
                        return null;
                    }
                    catch (Exception e) {
                        this.handleRecordException(record, jobInstance, e);
                    }
                }
            }
            catch (Exception e) {
                this.handleRecordException(record, jobInstance, e);
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug(String.format("Exception found in step %s processing record for instance %s of job %s. Record has been marked as failed in the step", this.name, jobInstance.getId(), jobInstance.getOwnerJobName()), (Throwable)e);
            }
        }
        return record;
    }

    private void handleRecordException(Record record, BatchJobInstanceAdapter jobInstance, Exception e) {
        if (e.getCause() instanceof InterruptedException) {
            throw new MuleRuntimeException(e.getCause());
        }
        record.markAsFailedInStep(this, e);
        this.exceptionReporter.report(jobInstance, e);
    }

    @Override
    public boolean finishIfCompleted(BatchJobInstanceAdapter jobInstance, BatchTransactionContext ctx) {
        long stepBatchSize = this.batchStepAggregator != null ? this.batchStepAggregator.size(jobInstance) : 0L;
        boolean isCompleted = this.isCompletedFor(jobInstance, stepBatchSize);
        if (isCompleted) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Step %s finished processing all records for instance %s of job %s", this.name, jobInstance.getId(), jobInstance.getOwnerJobName()));
            }
            this.notificationDispatcher.dispatch((Notification)new BatchNotification((BatchJobInstance)jobInstance, this, BatchNotification.STEP_JOB_END));
            this.exceptionReporter.reset(jobInstance);
            this.flushAggregator(jobInstance);
            if (!jobInstance.getStatus().isExecutable() && !jobInstance.getStatus().equals((Object)BatchJobInstanceStatus.STOPPED)) {
                this.batchEngine.getBatchQueueManager().disposeQueues(ctx);
            }
        }
        return isCompleted;
    }

    private CoreEvent processRecord(Record record, BatchJobInstanceAdapter jobInstance, BatchTransactionContext ctx) throws Exception {
        record.markAsProcessedByStep(this);
        this.notificationDispatcher.dispatch((Notification)new BatchNotification((BatchJobInstance)jobInstance, (BatchStep)this, record, BatchNotification.STEP_RECORD_START));
        RecordCompletableFuture externalCompletion = new RecordCompletableFuture(ctx.getResolutionCallback());
        record.setCompletionCallback(externalCompletion);
        CoreEvent coreEvent = null;
        coreEvent = this.resolveBatchJobStepRecordCoreEvent(record, jobInstance, ctx, externalCompletion);
        CoreEvent responseEvent = null;
        if (this.recordFilteringStrategy.acceptRecord(coreEvent, record)) {
            responseEvent = this.processingTemplate.process(jobInstance, coreEvent, this.coreEventTracer);
        }
        this.notificationDispatcher.dispatch((Notification)new BatchNotification((BatchJobInstance)jobInstance, (BatchStep)this, record, BatchNotification.STEP_RECORD_END));
        return responseEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreEvent resolveBatchJobStepRecordCoreEvent(Record record, BatchJobInstanceAdapter jobInstance, BatchTransactionContext ctx, RecordCompletableFuture externalCompletion) {
        CoreEvent coreEvent;
        Boolean bl = this.lock;
        synchronized (bl) {
            if (this.isNewBatchJobInstanceToProcess(ctx.getJobInstance().getId())) {
                coreEvent = this.batchEngine.createEventBuilder(record, jobInstance, externalCompletion).build();
                this.coreEventTracer.injectDistributedTraceContext(coreEvent.getContext(), (DistributedTraceContextGetter)new MapDistributedTraceContextGetter(this.serializedBatchStepSpan));
            } else {
                this.processingBatchJobInstanceId = ctx.getJobInstance().getId();
                coreEvent = this.batchEngine.createEventBuilder(record, jobInstance, externalCompletion).build();
                this.coreEventTracer.injectDistributedTraceContext(coreEvent.getContext(), (DistributedTraceContextGetter)new MapDistributedTraceContextGetter(ctx.getJobInstance().getBatchEvent().getSerializedBatchJobInstanceSpan()));
                this.stepSpan = this.coreEventTracer.startSpan((Event)coreEvent, this.initialSpanInfoProvider.getInitialSpanInfo((Component)this, BATCH_STEP_SPAN_NAME, "")).orElse(null);
                this.serializedBatchStepSpan = this.coreEventTracer.getDistributedTraceContextMap((Event)coreEvent);
            }
        }
        return coreEvent;
    }

    private boolean isNewBatchJobInstanceToProcess(String ctx) {
        return ctx.equals(this.processingBatchJobInstanceId);
    }

    private void flushAggregator(BatchJobInstanceAdapter jobInstance) {
        if (this.batchStepAggregator != null) {
            this.batchStepAggregator.flush(jobInstance);
        }
    }

    private boolean isCompletedFor(BatchJobInstance jobInstance, long stepBatchSize) {
        BatchStepResult result = jobInstance.getResult().getResultForStep(this.name);
        return result.getReceivedRecords() + stepBatchSize >= jobInstance.getRecordCount();
    }

    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.messageProcessorChain);
    }

    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public void setBatchStepAggregator(DefaultBatchStepAggregator batchStepAggregator) {
        this.batchStepAggregator = batchStepAggregator;
    }

    public void setAcceptPolicy(AcceptRecordPolicy acceptPolicy) {
        this.acceptPolicy = acceptPolicy;
    }

    public void setAcceptExpression(String expression) {
        this.acceptExpression = expression;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Inject
    public void setBatchEngine(BatchEngine batchEngine) {
        this.batchEngine = batchEngine;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    public void setNextStep(BatchStep nextStep) {
        this.nextStep = nextStep;
    }

    @Override
    public BatchStep getNextStep() {
        return this.nextStep;
    }

    @Override
    public ExceptionHistory getExceptionHistory(BatchJobInstanceAdapter jobInstance) {
        return this.exceptionReporter.getExceptionHistory(jobInstance);
    }

    @Override
    public DefaultBatchStepAggregator getBatchStepAggregator() {
        return this.batchStepAggregator;
    }

    public BatchEngine getBatchEngine() {
        return this.batchEngine;
    }

    public void setJob(BatchJobAdapter job) {
        this.job = job;
    }

    public void setExceptionReporter(StepExceptionReporter exceptionReporter) {
        this.exceptionReporter = exceptionReporter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BatchStep) {
            return this.name.equals(((BatchStep)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public void setNotificationDispatcher(NotificationDispatcher notificationFirer) {
        this.notificationDispatcher = notificationFirer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endStepSpan() {
        Boolean bl = this.lock;
        synchronized (bl) {
            this.serializedBatchStepSpan = Collections.emptyMap();
            if (this.stepSpan != null) {
                InternalSpan.getAsInternalSpan((Span)this.stepSpan).end();
                InternalSpan.getAsInternalSpan((Span)this.stepSpan.getParent()).end();
            }
            this.stepSpan = null;
        }
    }

    @Override
    public Map<String, String> getSerializedBatchStepSpan() {
        return this.serializedBatchStepSpan;
    }
}

