/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.config.quorum;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.mulesoft.mule.runtime.module.cluster.internal.quorum.HazelcastDefaultQuorumListener;

public final class HazelcastQuorumConfigurator {
    private static final String DEFAULT_MAP_CONFIG_NAME = "*";
    private static final String QUORUM_POSTFIX = "-quorum";
    private static final String DEFAULT_QUORUM_CONFIG = "default";

    private HazelcastQuorumConfigurator() {
    }

    public static void configureClusterQuorum(Config config, int quorumSize) {
        String clusterQuorumName = DEFAULT_QUORUM_CONFIG.concat(QUORUM_POSTFIX);
        SplitBrainProtectionListenerConfig quorumListenerConfig = new SplitBrainProtectionListenerConfig();
        quorumListenerConfig.setClassName(HazelcastDefaultQuorumListener.class.getName());
        SplitBrainProtectionConfig quorumConfig = new SplitBrainProtectionConfig();
        quorumConfig.setName(clusterQuorumName);
        quorumConfig.setEnabled(true);
        quorumConfig.setMinimumClusterSize(quorumSize);
        quorumConfig.addListenerConfig(quorumListenerConfig);
        MapConfig mapConfig = config.getMapConfig(DEFAULT_MAP_CONFIG_NAME);
        mapConfig.setSplitBrainProtectionName(clusterQuorumName);
        config.addSplitBrainProtectionConfig(quorumConfig);
        config.addMapConfig(mapConfig);
        if (quorumSize >= 3) {
            config.getCPSubsystemConfig().setCPMemberCount(quorumSize);
        }
    }
}

