/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamFramer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamFramer.class);
    private static final int END_OF_STREAM = -1;
    private final WebSocketFrameCallback callback;
    private final int bufferSize;
    private final InputStream inputStream;
    private final boolean isText;
    private boolean isFirstFrame = true;
    private byte[] lastFrameBuffer;
    private int lastFrameLength;

    public InputStreamFramer(InputStream inputStream, WebSocketFrameCallback callback, boolean isText) {
        this(inputStream, callback, isText, 8192);
    }

    public InputStreamFramer(InputStream inputStream, WebSocketFrameCallback callback, boolean isText, int maxFragmentSize) {
        this.inputStream = Objects.requireNonNull(inputStream, "Input stream must not be null");
        this.isText = isText;
        this.callback = callback;
        this.bufferSize = maxFragmentSize;
        this.lastFrameBuffer = new byte[maxFragmentSize];
        this.lastFrameLength = 0;
    }

    public void requestAllFrames() throws IOException {
        this.requestFrames(Long.MAX_VALUE);
    }

    public void requestFrames(long maxFrames) throws IOException {
        LOGGER.debug("Sending frames for a {} message", (Object)(this.isText ? "text" : "binary"));
        if (maxFrames == 0L) {
            return;
        }
        long sentInThisInvocation = 0L;
        if (this.isFirstFrame) {
            this.lastFrameBuffer = new byte[this.bufferSize];
            this.lastFrameLength = this.inputStream.read(this.lastFrameBuffer);
        }
        if (-1 == this.lastFrameLength) {
            WebSocketFrame frame = InputStreamFramer.newFrame(this.lastFrameBuffer, 0, true, this.isFirstFrame, this.isText);
            this.callback.onWebSocketFrame(frame);
            this.inputStream.close();
            this.callback.onStreamConsumed();
            return;
        }
        byte[] forwardFrameBuffer = new byte[this.bufferSize];
        boolean endOfStreamReached = false;
        while (!endOfStreamReached && sentInThisInvocation < maxFrames) {
            int forwardFrameLength = this.inputStream.read(forwardFrameBuffer);
            endOfStreamReached = -1 == forwardFrameLength;
            WebSocketFrame webSocketFrame = InputStreamFramer.newFrame(this.lastFrameBuffer, this.lastFrameLength, endOfStreamReached, this.isFirstFrame, this.isText);
            LOGGER.debug("About to send a frame type={}, length={}, final={}", new Object[]{webSocketFrame.getClass().getName(), this.lastFrameLength, webSocketFrame.isFinalFragment()});
            this.callback.onWebSocketFrame(webSocketFrame);
            ++sentInThisInvocation;
            this.isFirstFrame = false;
            this.lastFrameLength = forwardFrameLength;
            byte[] aux = forwardFrameBuffer;
            forwardFrameBuffer = this.lastFrameBuffer;
            this.lastFrameBuffer = aux;
        }
        if (endOfStreamReached) {
            this.inputStream.close();
            this.callback.onStreamConsumed();
        }
    }

    public void cancel() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            LOGGER.warn("There was a problem while closing a websocket message content stream", (Throwable)e);
        }
    }

    private static WebSocketFrame newFrame(byte[] buffer, int bytesActuallyRead, boolean isLastFrame, boolean isFirstFrame, boolean isText) {
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = byteBuf = bytesActuallyRead <= 0 ? Unpooled.EMPTY_BUFFER : ByteBufAllocator.DEFAULT.buffer(bytesActuallyRead, bytesActuallyRead).writeBytes(buffer, 0, bytesActuallyRead);
        if (isFirstFrame) {
            if (isText) {
                return new TextWebSocketFrame(isLastFrame, 0, byteBuf);
            }
            return new BinaryWebSocketFrame(isLastFrame, 0, byteBuf);
        }
        return new ContinuationWebSocketFrame(isLastFrame, 0, byteBuf);
    }

    public static interface WebSocketFrameCallback {
        public void onWebSocketFrame(WebSocketFrame var1);

        public void onStreamConsumed();
    }
}

