/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.util.List;

public final class MuleWebSocketServerProtocolHandler
extends WebSocketServerProtocolHandler {
    private final WebSocketServerProtocolConfig serverProtocolConfig;

    public MuleWebSocketServerProtocolHandler(WebSocketServerProtocolConfig serverProtocolConfig) {
        super(serverProtocolConfig);
        this.serverProtocolConfig = serverProtocolConfig;
    }

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (this.serverProtocolConfig.handleCloseFrames() && frame instanceof CloseWebSocketFrame) {
            out.add(frame.retainedDuplicate());
        }
        super.decode(ctx, frame, out);
    }

    public static WebSocketServerProtocolConfig defaultConfig() {
        return WebSocketServerProtocolConfig.newBuilder().websocketPath("/").checkStartsWith(true).handleCloseFrames(true).build();
    }
}

