/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.framework.dependency;

import com.mulesoft.mule.framework.api.dependency.DependencyResolutionException;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.api.annotation.Experimental;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

@Experimental
public class DefaultMuleFrameworkDependencyResolver
implements DependencyResolver {
    private final MavenClient mavenClient;
    private static final MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)DefaultMuleFrameworkDependencyResolver.class.getClassLoader());

    public DefaultMuleFrameworkDependencyResolver() {
        this(DefaultMuleFrameworkDependencyResolver.getDefaultMavenConfiguration());
    }

    public DefaultMuleFrameworkDependencyResolver(boolean offline) {
        this(DefaultMuleFrameworkDependencyResolver.getDefaultMavenConfiguration(offline));
    }

    public DefaultMuleFrameworkDependencyResolver(MavenConfiguration mavenConfig) {
        this.mavenClient = mavenClientProvider.createMavenClient(mavenConfig);
    }

    private static MavenConfiguration getDefaultMavenConfiguration() {
        return DefaultMuleFrameworkDependencyResolver.getDefaultMavenConfiguration(false);
    }

    private static MavenConfiguration getDefaultMavenConfiguration(boolean offline) {
        Supplier localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).offlineMode(offline).localMavenRepositoryLocation((File)localMavenRepository.get());
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSecurity.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    @Override
    public BundleDependency resolveFor(BundleDescriptor bundleDescriptor) throws DependencyResolutionException {
        BundleDependency resolvedBundleDependency;
        try {
            resolvedBundleDependency = (BundleDependency)this.mavenClient.resolveArtifactDependencies(Collections.singletonList(bundleDescriptor), Optional.empty(), Optional.empty()).get(0);
        }
        catch (RuntimeException e) {
            throw new DependencyResolutionException(I18nMessageFactory.createStaticMessage((String)e.getCause().getMessage()), e);
        }
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(resolvedBundleDependency.getDescriptor()).setScope(BundleScope.valueOf((String)resolvedBundleDependency.getScope().name())).setBundleUri(resolvedBundleDependency.getBundleUri());
        this.getTransitiveDependencies(resolvedBundleDependency).forEach(arg_0 -> ((BundleDependency.Builder)builder).addTransitiveDependency(arg_0));
        return builder.build();
    }

    private List<BundleDependency> getTransitiveDependencies(BundleDependency resolvedBundleDependency) {
        ArrayList<BundleDependency> transitiveDeps = new ArrayList<BundleDependency>();
        HashSet<String> seen = new HashSet<String>();
        this.getTransitiveDependencies(resolvedBundleDependency.getTransitiveDependencies(), transitiveDeps, seen);
        return transitiveDeps;
    }

    private void getTransitiveDependencies(List<BundleDependency> dependencies, List<BundleDependency> transitiveDeps, Set<String> seen) {
        dependencies.forEach(dependency -> {
            String key = dependency.getDescriptor().getGroupId() + ":" + dependency.getDescriptor().getArtifactId() + ":" + dependency.getDescriptor().getClassifier().orElse("");
            if (!seen.contains(key)) {
                transitiveDeps.add((BundleDependency)dependency);
                this.getTransitiveDependencies(dependency.getTransitiveDependencies(), transitiveDeps, seen);
                seen.add(key);
            }
        });
    }

    @Override
    public BundleDependency resolveArtifact(BundleDescriptor descriptor) throws DependencyResolutionException {
        try {
            return this.mavenClient.resolveBundleDescriptor(descriptor);
        }
        catch (BundleDependenciesResolutionException e) {
            throw new DependencyResolutionException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), e);
        }
    }

    public void dispose() {
        try {
            this.mavenClient.close();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while disposing dependency resolver"), (Throwable)e);
        }
    }
}

