/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.framework.api.builder.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static List<URL> getDependenciesFromPath(Path dependenciesLocation, Predicate<Path> filter) {
        List<URL> list;
        block8: {
            Stream<Path> dependencies = Files.walk(dependenciesLocation, new FileVisitOption[0]);
            try {
                list = dependencies.skip(1L).filter(filter).filter(path -> path.toString().endsWith("jar")).map(dependency -> FileUtils.uriToUrl(dependency.toUri())).collect(Collectors.toList());
                if (dependencies == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dependencies != null) {
                        try {
                            dependencies.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            dependencies.close();
        }
        return list;
    }

    public static List<URL> getDependenciesFromZip(Path zippedDependencies, Predicate<Path> filter) {
        Path unzippedDependencies;
        try {
            unzippedDependencies = FileUtils.unzip(zippedDependencies, FileUtils.createDir(FileUtils.createTempDir(), ".unzippedDependencies").toPath(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path dependenciesLocation = FileUtils.findLibsDirectory(unzippedDependencies);
        return FileUtils.getDependenciesFromPath(dependenciesLocation, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream archive, File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("Directory is not a directory: " + directory);
            }
        } else if (!directory.mkdirs()) {
            throw new IOException("Could not create directory: " + directory);
        }
        try (ZipInputStream zis = new ZipInputStream(archive);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(directory, entry.getName()).getCanonicalFile();
                if (entry.isDirectory()) {
                    if (file.exists() || file.mkdirs()) continue;
                    throw new IOException("Could not create directory: " + file);
                }
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new IOException("Unable to create folders for zip entry: " + entry.getName());
                }
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    IOUtils.copy((InputStream)zis, (OutputStream)os);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)os);
                }
            }
        }
    }

    private static Path unzip(Path source, Path destination, boolean temp) throws IOException {
        Path distro = null;
        try (ZipFile zip = new ZipFile(source.toFile());){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File f = new File(destination.toFile(), entry.getName()).getCanonicalFile();
                f.deleteOnExit();
                if (distro == null) {
                    distro = f.toPath();
                }
                if (entry.isDirectory()) {
                    if (f.exists() || f.mkdirs()) continue;
                    throw new IOException("Could not create directory: " + f);
                }
                File file = FileUtils.getFile(destination, entry, temp);
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new IOException("Unable to create folders for zip entry: " + entry.getName());
                }
                InputStream is = zip.getInputStream(entry);
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return distro;
    }

    private static File getFile(Path destination, ZipEntry entry, boolean temp) throws IOException {
        String canonicalPathWithoutEntry;
        File file = new File(destination.toFile(), entry.getName());
        String canonicalDestinationPath = file.getCanonicalPath();
        if (!canonicalDestinationPath.startsWith(canonicalPathWithoutEntry = destination.toFile().getCanonicalPath()) || entry.isDirectory() && !canonicalDestinationPath.endsWith(File.separator)) {
            throw new RuntimeException(String.format("Destination path '%s' expected to start with '%s' and end with '%s' if it's a directory", canonicalDestinationPath, canonicalPathWithoutEntry, File.separator));
        }
        if (temp) {
            file.deleteOnExit();
        }
        return file;
    }

    private static Path findLibsDirectory(Path startPath) {
        Path path2;
        block8: {
            Stream<Path> paths = Files.walk(startPath, new FileVisitOption[0]);
            try {
                path2 = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().equals("lib")).findFirst().orElseThrow(() -> new RuntimeException(String.format("No 'lib' directory found under %s", startPath)));
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            paths.close();
        }
        return path2;
    }

    private static File createTempDir() {
        try {
            File tempFolder = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
            tempFolder.deleteOnExit();
            return tempFolder;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File createDir(File destination, String name) {
        File dir = new File(destination, name);
        dir.deleteOnExit();
        if (!dir.mkdir()) {
            throw new RuntimeException("Error while loading 'mule-framework' dependencies, cannot create directory " + dir.getAbsolutePath());
        }
        return dir;
    }

    private static URL uriToUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

