/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.framework.utils;

import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JpmsUtils {
    public static final String JPMS_UTILS_MODULE_NAME = "org.mule.runtime.jpms.utils";

    public static ClassLoader createJpmsUtilsClassLoader(URL jpmsUtilsLib) {
        ModuleFinder finder;
        if (!JpmsUtils.useModuleLayer()) {
            return new URLClassLoader(new URL[]{jpmsUtilsLib}, null);
        }
        try {
            finder = ModuleFinder.of(Paths.get(jpmsUtilsLib.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ModuleLayer parent = ModuleLayer.boot();
        Set<String> roots = finder.findAll().stream().map(moduleRef -> moduleRef.descriptor().name()).collect(Collectors.toSet());
        Configuration configuration = parent.configuration().resolve(finder, ModuleFinder.ofSystem(), roots);
        ModuleLayer layer = parent.defineModulesWithOneLoader(configuration, JpmsUtils.class.getClassLoader());
        JpmsUtils.openToModule(layer, JPMS_UTILS_MODULE_NAME, "java.base", Arrays.asList("java.lang", "java.lang.reflect", "java.lang.invoke"));
        return layer.findLoader(JPMS_UTILS_MODULE_NAME);
    }

    private static boolean useModuleLayer() {
        return Boolean.parseBoolean(System.getProperty("mule.classloader.container.jpmsModuleLayer", "" + SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)));
    }

    private static void openToModule(ModuleLayer layer, String moduleName, String bootModuleName, List<String> packages) {
        layer.findModule(moduleName).ifPresent(module -> ModuleLayer.boot().findModule(bootModuleName).ifPresent(bootModule -> {
            for (String pkg : packages) {
                bootModule.addOpens(pkg, (Module)module);
            }
        }));
    }
}

