/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.framework.api.builder;

import com.mulesoft.mule.framework.api.MuleFramework;
import com.mulesoft.mule.framework.api.builder.MuleVersionConfigurer;
import com.mulesoft.mule.framework.api.builder.util.FileUtils;
import com.mulesoft.mule.framework.api.dependency.DependencyResolutionException;
import com.mulesoft.mule.framework.builder.DefaultMuleVersionConfigurer;
import com.mulesoft.mule.framework.utils.JpmsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;
import org.mule.runtime.module.embedded.api.ContainerInformation;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.runtime.module.embedded.api.dependencies.DependencyResolver;
import org.mule.runtime.module.embedded.api.dependencies.MuleDependenciesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public abstract class AbstractMuleFrameworkBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMuleFrameworkBuilderFactory.class);
    private static final String ARTIFACT_INFO_PROPERTIES = "framework-artifact-info.properties";
    private static final String DISABLE_FACTORIES_CACHE_PROPERTY = "mule.embedded.framework.disable.factories.cache";
    private static final MuleVersion DEFAULT_MULE_VERSION = new MuleVersion(AbstractMuleFrameworkBuilderFactory.getDefaultMuleVersion());
    private static List<URL> muleFrameworkImplDependencies;
    private static final AbstractMuleFrameworkBuilderFactory STATIC_FACTORY;
    private static final Map<MuleVersion, AbstractMuleFrameworkBuilderFactory> factoriesPerMuleVersion;
    private com.mulesoft.mule.framework.api.dependency.DependencyResolver dependencyResolver;
    private MuleVersion muleVersion;
    private List<URL> muleServices;

    private static String getMuleFrameworkImplVersion() {
        return AbstractMuleFrameworkBuilderFactory.getArtifactInfoProperty("artifact-version");
    }

    private static String getDefaultMuleVersion() {
        return AbstractMuleFrameworkBuilderFactory.getArtifactInfoProperty("default-mule-version");
    }

    private static String getArtifactInfoProperty(String key) {
        try {
            Properties artifactInfo = new Properties();
            artifactInfo.load(AbstractMuleFrameworkBuilderFactory.class.getClassLoader().getResourceAsStream(ARTIFACT_INFO_PROPERTIES));
            return artifactInfo.getProperty(key);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isStaticFramework() {
        try {
            AbstractMuleFrameworkBuilderFactory.class.getClassLoader().loadClass("org.mule.framework.impl.builder.DefaultMuleFrameworkBuilderFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean loadedAsModule() {
        if (!SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)) {
            return false;
        }
        try {
            Object module = Class.class.getMethod("getModule", new Class[0]).invoke(AbstractMuleFrameworkBuilderFactory.class, new Object[0]);
            return (Boolean)module.getClass().getMethod("isNamed", new Class[0]).invoke(module, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static AbstractMuleFrameworkBuilderFactory loadFactory(ClassLoader classLoader) {
        AbstractMuleFrameworkBuilderFactory factory = ServiceLoader.load(AbstractMuleFrameworkBuilderFactory.class, classLoader).iterator().next();
        LOGGER.info("Loaded AbstractMuleFrameworkBuilderFactory implementation '{}' from classloader '{}'", (Object)factory.getClass().getName(), (Object)factory.getClass().getClassLoader());
        return factory;
    }

    public static AbstractMuleFrameworkBuilderFactory getDefaultFactory() {
        return AbstractMuleFrameworkBuilderFactory.getFactory((DefaultMuleVersionConfigurer)new DefaultMuleVersionConfigurer().withMuleVersion(DEFAULT_MULE_VERSION));
    }

    public static AbstractMuleFrameworkBuilderFactory getDefaultFactory(Consumer<MuleVersionConfigurer> muleVersionConfigurerConsumer) {
        return AbstractMuleFrameworkBuilderFactory.getDefaultFactory(muleVersionConfigurerConsumer, null);
    }

    public static AbstractMuleFrameworkBuilderFactory getDefaultFactory(Consumer<MuleVersionConfigurer> muleVersionConfigurerConsumer, Path frameworkImplDepsBundleDir) {
        Preconditions.checkState((STATIC_FACTORY == null ? 1 : 0) != 0, (String)"Mule Framework implementation already present");
        DefaultMuleVersionConfigurer muleVersionConfigurer = new DefaultMuleVersionConfigurer();
        muleVersionConfigurerConsumer.accept(muleVersionConfigurer);
        muleVersionConfigurer.validate();
        return AbstractMuleFrameworkBuilderFactory.getFactory(muleVersionConfigurer, frameworkImplDepsBundleDir);
    }

    public static Optional<AbstractMuleFrameworkBuilderFactory> existingFactoryFor(MuleVersion muleVersion) {
        if (STATIC_FACTORY != null) {
            return Optional.of(STATIC_FACTORY);
        }
        return Optional.ofNullable(factoriesPerMuleVersion.get(muleVersion));
    }

    private static AbstractMuleFrameworkBuilderFactory getFactory(DefaultMuleVersionConfigurer muleVersionConfigurer) {
        return AbstractMuleFrameworkBuilderFactory.getFactory(muleVersionConfigurer, null);
    }

    private static AbstractMuleFrameworkBuilderFactory getFactory(DefaultMuleVersionConfigurer muleVersionConfigurer, Path frameworkImplDepsBundleDir) {
        AbstractMuleFrameworkBuilderFactory factory;
        if (STATIC_FACTORY != null) {
            return STATIC_FACTORY;
        }
        LOGGER.info("Building factory for Mule Runtime version {}", (Object)muleVersionConfigurer.getMuleVersion());
        if (muleVersionConfigurer.getMuleDistribution() != null) {
            LOGGER.info("Building from Mule Runtime distribution in '{}'", (Object)muleVersionConfigurer.getMuleDistribution());
        } else {
            LOGGER.info("No Mule Runtime distribution provided");
        }
        AbstractMuleFrameworkBuilderFactory abstractMuleFrameworkBuilderFactory = factory = AbstractMuleFrameworkBuilderFactory.isCacheFactories() ? factoriesPerMuleVersion.get(muleVersionConfigurer.getMuleVersion()) : null;
        if (factory != null) {
            LOGGER.info("Using cached factory");
            return factory;
        }
        MuleVersion muleVersion = muleVersionConfigurer.getMuleVersion();
        com.mulesoft.mule.framework.api.dependency.DependencyResolver frameworkDependencyResolver = muleVersionConfigurer.getDependencyResolver() != null ? muleVersionConfigurer.getDependencyResolver() : com.mulesoft.mule.framework.api.dependency.DependencyResolver.defaultDependencyResolver(muleVersionConfigurer.isOffline());
        ProxyDependencyResolver embeddedDependencyResolver = new ProxyDependencyResolver(frameworkDependencyResolver);
        MuleDependenciesResolver muleDependenciesResolver = MuleDependenciesResolver.getMuleDependenciesResolver((Product)Product.MULE_EE, (String)muleVersion.toString(), Collections.emptyList(), (DependencyResolver)embeddedDependencyResolver, (Path)muleVersionConfigurer.getMuleDistribution(), (boolean)false);
        ClassLoader frameworkImplClassLoader = AbstractMuleFrameworkBuilderFactory.createFrameworkImplClassLoader(muleDependenciesResolver, frameworkDependencyResolver, frameworkImplDepsBundleDir);
        ContainerInformation containerInformation = ContainerInformation.fromContainerClassLoader((ClassLoader)frameworkImplClassLoader);
        MuleVersion actualVersion = new MuleVersion(containerInformation.getMuleContainerVersion());
        AbstractMuleFrameworkBuilderFactory.validateVersion(muleVersion, actualVersion, containerInformation);
        factory = AbstractMuleFrameworkBuilderFactory.loadFactory(frameworkImplClassLoader);
        factory.setMuleVersion(actualVersion);
        factory.setMuleServices(muleDependenciesResolver.resolveMuleServices());
        if (muleVersionConfigurer.getDependencyResolver() != null) {
            factory.setDependencyResolver(muleVersionConfigurer.getDependencyResolver());
        } else {
            frameworkDependencyResolver.dispose();
        }
        if (AbstractMuleFrameworkBuilderFactory.isCacheFactories()) {
            factoriesPerMuleVersion.put(muleVersionConfigurer.getMuleVersion(), factory);
        }
        System.setProperty("mule.resolve.mule.implementations.loader.dynamically", "true");
        MuleImplementationLoaderUtils.forceLookup();
        System.setProperty("mule.server.action.repetition.allowed", "true");
        return factory;
    }

    private static void validateVersion(MuleVersion muleVersion, MuleVersion actualVersion, ContainerInformation containerInformation) {
        if (!actualVersion.sameBaseVersion(muleVersion)) {
            if (!actualVersion.atLeastBase(muleVersion)) {
                throw new RuntimeException("The actual version to be used (" + actualVersion + ") does not match the expected version (" + muleVersion + "). Expected minor version must at most match the actual minor version.");
            }
            LOGGER.info("Expected version {} but found {}", (Object)muleVersion, (Object)actualVersion);
        }
        if (!containerInformation.isCurrentJvmVersionSupported()) {
            throw new RuntimeException("Version " + actualVersion + " doesn't support JVM version " + System.getProperty("java.version"));
        }
    }

    private static boolean isCacheFactories() {
        return !Boolean.getBoolean(DISABLE_FACTORIES_CACHE_PROPERTY);
    }

    private static ClassLoader createFrameworkImplClassLoader(MuleDependenciesResolver muleDependenciesResolver, com.mulesoft.mule.framework.api.dependency.DependencyResolver dependencyResolver, Path frameworkImplDepsBundleDir) {
        List optUrls = muleDependenciesResolver.resolveOptLibs();
        List muleUrls = muleDependenciesResolver.resolveMuleLibs();
        ArrayList<URL> embeddedUrls = new ArrayList<URL>(AbstractMuleFrameworkBuilderFactory.getMuleFrameworkImplDependencies(dependencyResolver, frameworkImplDepsBundleDir));
        embeddedUrls.addAll(muleUrls);
        return AbstractMuleFrameworkBuilderFactory.createModuleLayerClassLoader(optUrls.toArray(new URL[optUrls.size()]), embeddedUrls.toArray(new URL[embeddedUrls.size()]), AbstractMuleFrameworkBuilderFactory.class.getClassLoader());
    }

    private static ClassLoader createModuleLayerClassLoader(URL[] optUrls, URL[] muleUrls, ClassLoader parentClassLoader) {
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11)) {
            return new URLClassLoader(muleUrls, (ClassLoader)new URLClassLoader(optUrls, parentClassLoader));
        }
        ClassLoader jpmsUtilsClassLoader = AbstractMuleFrameworkBuilderFactory.getJpmsUtilsClassLoader(muleUrls);
        try {
            Class<?> multiLevelClassLoaderFactoryClass = jpmsUtilsClassLoader.loadClass("org.mule.runtime.jpms.api.MultiLevelClassLoaderFactory");
            Object multiLevelClassLoaderFactoryImpl = multiLevelClassLoaderFactoryClass.getField("MULTI_LEVEL_URL_CLASSLOADER_FACTORY").get(null);
            List<Class> parameterTypes = Arrays.asList(URL[].class, URL[].class, multiLevelClassLoaderFactoryClass, ClassLoader.class);
            List<Object> parameters = Arrays.asList(optUrls, muleUrls, multiLevelClassLoaderFactoryImpl, parentClassLoader);
            Method createModuleLayerClassLoaderMethod = jpmsUtilsClassLoader.loadClass("org.mule.runtime.jpms.api.JpmsUtils").getMethod("createModuleLayerClassLoader", parameterTypes.toArray(new Class[parameterTypes.size()]));
            return (ClassLoader)createModuleLayerClassLoaderMethod.invoke(null, parameters.toArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassLoader getJpmsUtilsClassLoader(URL[] muleLibs) {
        String jpmsUtilsLibName = "mule-module-jpms-utils";
        URL jpmsUtilsLib = Arrays.stream(muleLibs).filter(url -> url.toExternalForm().contains(jpmsUtilsLibName)).findFirst().orElse(null);
        if (jpmsUtilsLib == null) {
            throw new RuntimeException("Could not find '" + jpmsUtilsLibName + "' among mule libs");
        }
        return JpmsUtils.createJpmsUtilsClassLoader(jpmsUtilsLib);
    }

    private void setDependencyResolver(com.mulesoft.mule.framework.api.dependency.DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    protected com.mulesoft.mule.framework.api.dependency.DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    private void setMuleVersion(MuleVersion muleVersion) {
        this.muleVersion = muleVersion;
    }

    private void setMuleServices(List<URL> muleServices) {
        this.muleServices = muleServices;
    }

    protected MuleVersion getMuleVersion() {
        return this.muleVersion;
    }

    protected List<URL> getMuleServices() {
        return this.muleServices;
    }

    private static List<URL> getMuleFrameworkImplDependencies(com.mulesoft.mule.framework.api.dependency.DependencyResolver dependencyResolver, Path frameworkImplDepsBundleDir) {
        if (muleFrameworkImplDependencies == null) {
            muleFrameworkImplDependencies = frameworkImplDepsBundleDir == null ? Collections.unmodifiableList(AbstractMuleFrameworkBuilderFactory.getMuleFrameworkImplDependencies(dependencyResolver)) : Collections.unmodifiableList(AbstractMuleFrameworkBuilderFactory.getMuleFrameworkImplDependencies(frameworkImplDepsBundleDir));
        }
        return muleFrameworkImplDependencies;
    }

    private static List<URL> getMuleFrameworkImplDependencies(com.mulesoft.mule.framework.api.dependency.DependencyResolver dependencyResolver) {
        BundleDependency muleFrameworkImplDependenciesBundleDependency;
        BundleDescriptor muleFrameworkImplDependenciesDescriptor = new BundleDescriptor.Builder().setGroupId("com.mulesoft.mule.framework").setArtifactId("mule-framework").setVersion(AbstractMuleFrameworkBuilderFactory.getMuleFrameworkImplVersion()).setClassifier("dependencies").setType("zip").build();
        try {
            muleFrameworkImplDependenciesBundleDependency = dependencyResolver.resolveArtifact(muleFrameworkImplDependenciesDescriptor);
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        return FileUtils.getDependenciesFromZip(Paths.get(muleFrameworkImplDependenciesBundleDependency.getBundleUri()), AbstractMuleFrameworkBuilderFactory::shouldKeepXmlApis);
    }

    private static List<URL> getMuleFrameworkImplDependencies(Path frameworkImplDepsBundleDir) {
        return FileUtils.getDependenciesFromPath(frameworkImplDepsBundleDir, AbstractMuleFrameworkBuilderFactory::shouldKeepXmlApis);
    }

    private static boolean shouldKeepXmlApis(Path jar) {
        if (SystemUtils.IS_JAVA_1_8) {
            return true;
        }
        return !jar.toString().contains("xml-apis");
    }

    public abstract MuleFramework.Builder create();

    public abstract MuleFramework.Builder create(ClassLoader var1, InputStream var2);

    public abstract void keepServicesAliveAfterLastFrameworkClosed(boolean var1);

    public abstract void reuseGeneratedModuleRepository(boolean var1);

    public abstract void disposeServices();

    static {
        factoriesPerMuleVersion = new HashMap<MuleVersion, AbstractMuleFrameworkBuilderFactory>();
        if (AbstractMuleFrameworkBuilderFactory.isStaticFramework()) {
            try {
                STATIC_FACTORY = AbstractMuleFrameworkBuilderFactory.loadFactory(AbstractMuleFrameworkBuilderFactory.class.getClassLoader());
            }
            catch (Throwable t) {
                LOGGER.error("Error loading AbstractMuleFrameworkBuilderFactory implementation.", t);
                throw t;
            }
        } else {
            STATIC_FACTORY = null;
        }
        if (!AbstractMuleFrameworkBuilderFactory.loadedAsModule()) {
            System.setProperty("mule.classloader.container.jpmsModuleLayer", "false");
        }
    }

    private static class ProxyDependencyResolver
    implements DependencyResolver {
        private final com.mulesoft.mule.framework.api.dependency.DependencyResolver delegateDependencyResolver;

        public ProxyDependencyResolver(com.mulesoft.mule.framework.api.dependency.DependencyResolver dependencyResolver) {
            this.delegateDependencyResolver = dependencyResolver;
        }

        public List<BundleDependency> resolveBundleDescriptorDependencies(BundleDescriptor descriptor) {
            try {
                return this.delegateDependencyResolver.resolveFor(descriptor).getTransitiveDependencies();
            }
            catch (DependencyResolutionException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }

        public BundleDependency resolveBundleDescriptor(BundleDescriptor descriptor) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

