/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.state;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.backoff.state.BackingOff;
import com.mulesoft.anypoint.backoff.state.Error;
import com.mulesoft.anypoint.backoff.state.State;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public class Stable
extends State {
    public Stable(BackoffConfiguration configuration, BackoffBarrier backoffBarrier) {
        super(configuration, backoffBarrier);
    }

    @Override
    public State next(SessionMetadata sessionMetadata) {
        if (this.backoffBarrier.gotError(sessionMetadata)) {
            return new Error(this.configuration, this.backoffBarrier, 1);
        }
        return this.backoffBarrier.shouldBackoff(sessionMetadata, this.configuration) ? new BackingOff(this.configuration, this.backoffBarrier, 1) : this;
    }

    @Override
    public Period delay() {
        return Period.millis((long)0L);
    }

    @Override
    public State go() {
        this.stableClosure.ifPresent(Runnable::run);
        return this.resetClosures();
    }

    @Override
    public State log() {
        return this;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Stable;
    }

    public String toString() {
        return "Stable{}";
    }
}

