/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.scheduler.runnable;

import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.observer.ReschedulingObserver;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;

public class Reschedulable
implements Runnable {
    private final BackoffRunnable innerRunnable;
    private final SchedulingConfiguration configuration;
    private final ReschedulingObserver reschedulingObserver;

    public Reschedulable(BackoffRunnable runnable, SchedulingConfiguration configuration, ReschedulingObserver reschedulingObserver) {
        this.innerRunnable = runnable;
        this.configuration = configuration;
        this.reschedulingObserver = reschedulingObserver;
    }

    @Override
    public void run() {
        this.innerRunnable.run();
        this.innerRunnable.ifUnstable(() -> this.reschedulingObserver.reschedule(this.innerRunnable, this.backoffConfiguration())).ifError(() -> this.reschedulingObserver.reschedule(this.innerRunnable, this.backoffConfiguration())).otherwise(() -> this.reschedulingObserver.reschedule(this.innerRunnable, this.regularConfiguration())).go();
    }

    private SchedulingConfiguration backoffConfiguration() {
        return SchedulingConfiguration.configuration(this.innerRunnable.delay(), this.configuration.frequency());
    }

    private SchedulingConfiguration regularConfiguration() {
        return SchedulingConfiguration.configuration(this.configuration.frequency(), this.configuration.frequency());
    }
}

