/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.google.common.base.Preconditions;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.policy.api.PolicyPointcut;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiPointcutAdapter
implements PolicyPointcut {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiPointcutAdapter.class);
    private final String flowName;
    private final String policyName;

    public ApiPointcutAdapter(String policyName, String flowName) {
        Preconditions.checkNotNull((Object)flowName, (Object)"Flow name can not be null");
        this.policyName = policyName;
        this.flowName = flowName;
    }

    public boolean matches(PolicyPointcutParameters policyPointcutParameters) {
        Preconditions.checkArgument((!policyPointcutParameters.getComponent().getLocation().getParts().isEmpty() ? 1 : 0) != 0, (Object)"Pointcuts parameter must have a component location");
        String flowInExecution = ((LocationPart)policyPointcutParameters.getSourceParameters().orElse(policyPointcutParameters).getComponent().getLocation().getParts().get(0)).getPartPath();
        if (!this.flowName.equals(flowInExecution)) {
            LOGGER.trace("Executing flow {} does not match API's flow {} for policy {}", new Object[]{flowInExecution, this.flowName, this.policyName});
            return false;
        }
        LOGGER.trace("Executing flow matches API's flow {} for policy {}", (Object)this.flowName, (Object)this.policyName);
        return true;
    }
}

