/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.contracts.repository;

import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.internal.encryption.GatewayEncryptionException;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.EncryptedContractsRepository;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotEncryptedContractRepository
implements ContractRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedContractsRepository.class);
    private final ContractRepository decoratee;
    private final RuntimeEncrypter encrypter;

    public NotEncryptedContractRepository(ContractRepository decoratee, RuntimeEncrypter encrypter) {
        this.decoratee = decoratee;
        this.encrypter = encrypter;
    }

    @Override
    public void store(ApiKey apiKey, Collection<Contract> contracts) {
        this.decoratee.store(apiKey, contracts);
    }

    @Override
    public void storeSlas(ApiKey apiKey, Collection<Sla> slas) {
        this.decoratee.storeSlas(apiKey, slas);
    }

    @Override
    public Set<Contract> load(ApiKey apiKey) {
        Set<Contract> contracts = this.decoratee.load(apiKey);
        try {
            contracts.stream().forEach(this::checkIfEncrypted);
        }
        catch (GatewayEncryptionException e) {
            LOGGER.warn("Loading encrypted contracts without giving an encryption key");
        }
        return contracts;
    }

    @Override
    public void delete(ApiKey apiKey) {
        this.decoratee.delete(apiKey);
    }

    @Override
    public boolean contains(ApiKey apiKey) {
        return this.decoratee.contains(apiKey);
    }

    @Override
    public boolean containsSla(ApiKey apiKey) {
        return this.decoratee.containsSla(apiKey);
    }

    @Override
    public void compact() {
        this.decoratee.compact();
    }

    public void dispose() {
        this.decoratee.dispose();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof NotEncryptedContractRepository)) {
            return false;
        }
        NotEncryptedContractRepository that = (NotEncryptedContractRepository)o;
        return this.decoratee.equals(that.decoratee);
    }

    private void checkIfEncrypted(Contract contract) {
        this.encrypter.decrypt(contract.client().secret());
    }
}

