/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.vm;

import com.hazelcast.collection.IQueue;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastTimeoutUtils;
import com.mulesoft.mule.runtime.module.cluster.internal.serialization.SerializationSaavyQueueSupport;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.internal.util.queue.QueueStore;

public class ClusterQueueStore
extends SerializationSaavyQueueSupport
implements QueueStore,
Startable,
Stoppable {
    private final String name;
    private final QueueConfiguration config;
    private final IQueue<Object> queue;

    public ClusterQueueStore(String name, QueueConfiguration config, IQueue<Object> queue, ObjectSerializer objectSerializer) {
        super(objectSerializer);
        this.config = config;
        this.name = name;
        this.queue = queue;
    }

    public String getName() {
        return this.name;
    }

    public void putNow(Serializable o) throws InterruptedException {
        this.queue.put((Object)this.serialize(o));
    }

    public boolean offer(Serializable o, int room, long timeout) throws InterruptedException {
        return HazelcastTimeoutUtils.executeWithTimeoutIntervals(timeout, t -> this.queue.offer((Object)this.serialize(o), t.longValue(), TimeUnit.MILLISECONDS), result -> result);
    }

    public Serializable poll(long timeout) throws InterruptedException {
        return (Serializable)this.deserialize(HazelcastTimeoutUtils.executeWithTimeoutIntervals(timeout, t -> this.queue.poll(t.longValue(), TimeUnit.MILLISECONDS), Objects::nonNull));
    }

    public Serializable peek() throws InterruptedException {
        return (Serializable)this.deserialize((Serializable)this.queue.peek());
    }

    public void untake(Serializable item) throws InterruptedException {
        this.queue.put((Object)this.serialize(item));
    }

    public int getSize() {
        return this.queue.size();
    }

    public void clear() throws InterruptedException {
        this.queue.clear();
    }

    public void dispose() {
        this.queue.destroy();
    }

    public int getCapacity() {
        return this.config.getCapacity();
    }

    public void close() {
    }

    public boolean isPersistent() {
        return false;
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public String toString() {
        return ClusterQueueStore.class.getSimpleName() + "{name: '" + this.name + "', config: '" + this.config + "'}";
    }
}

