/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.serialization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import java.util.List;
import java.util.stream.Collectors;

public class PointcutsDto {
    @JsonProperty(value="resources")
    private List<HttpResourcePointcutDTO> resources;

    public static PointcutsDto from(List<HttpResourcePointcut> httpResourcePointcuts) {
        List resourcesDTO = null;
        if (httpResourcePointcuts != null && !httpResourcePointcuts.isEmpty()) {
            resourcesDTO = httpResourcePointcuts.stream().map(resourcePointcut -> new HttpResourcePointcutDTO(resourcePointcut.getPath(), resourcePointcut.getMethod())).collect(Collectors.toList());
        }
        PointcutsDto pointcutsDto = new PointcutsDto();
        pointcutsDto.resources = resourcesDTO;
        return pointcutsDto;
    }

    public List<HttpResourcePointcutDTO> getResources() {
        return this.resources;
    }

    public static class HttpResourcePointcutDTO {
        private String path;
        private String method;

        public HttpResourcePointcutDTO() {
        }

        public HttpResourcePointcutDTO(String path, String method) {
            this.path = path;
            this.method = method;
        }

        public String getPath() {
            return this.path;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

