/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.model;

import com.mulesoft.mule.runtime.gw.analytics.extractor.ClientIpExtractor;
import com.mulesoft.mule.runtime.gw.analytics.feedbackloop.EdgeRequestDetector;
import com.mulesoft.mule.runtime.gw.analytics.model.AnalyticsEventBuilder;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpRequestAttributes;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpRequestAttributesFactory;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpResponseAttributes;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpResponseAttributesFactory;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import com.mulesoft.mule.runtime.gw.api.analytics.RequestDisposition;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.model.Api;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.OptionalLong;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsHttpEventBuilder
implements AnalyticsEventBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsHttpEventBuilder.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = ISODateTimeFormat.dateTime();
    private static final String CONTENT_LENGTH_LOWER = "Content-Length".toLowerCase();
    private static final String USER_AGENT_LOWER = "User-Agent".toLowerCase();
    private static final String VIA_HEADER = "Via".toLowerCase();
    private static String hostname = AnalyticsHttpEventBuilder.getHostname();
    private final AnalyticsHttpEvent.Builder httpEvent;
    private final EdgeRequestDetector edgeRequestDetector;
    private final HttpRequestAttributesFactory httpRequestAttributesFactory;
    private final HttpResponseAttributesFactory httpResponseAttributesFactory;
    private final ClientIpExtractor clientIpExtractor;
    private String apiDescription;
    private LazyValue<Boolean> isEdgeRequest;

    public AnalyticsHttpEventBuilder(EdgeRequestDetector edgeRequestDetector, HttpRequestAttributesFactory httpRequestAttributesFactory, HttpResponseAttributesFactory httpResponseAttributesFactory, ClientIpExtractor clientIpExtractor) {
        this.edgeRequestDetector = edgeRequestDetector;
        this.httpRequestAttributesFactory = httpRequestAttributesFactory;
        this.httpResponseAttributesFactory = httpResponseAttributesFactory;
        this.clientIpExtractor = clientIpExtractor;
        this.httpEvent = AnalyticsHttpEvent.builder();
        this.httpEvent.withRequestDisposition(RequestDisposition.PROCESSED);
        this.httpEvent.withHostId(hostname);
    }

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.error("Local hostname could not be retrieved. Analytics events will not include it", (Throwable)e);
            return null;
        }
    }

    @Override
    public AnalyticsHttpEvent build() {
        return this.httpEvent.build();
    }

    @Override
    public AnalyticsHttpEventBuilder withApi(Api api) {
        this.apiDescription = api.toString();
        this.httpEvent.withApiVersionId(api.getKey().id());
        this.httpEvent.withApiName(api.getTrackingInfo().getExchangeAssetName());
        this.httpEvent.withApiVersion(api.getTrackingInfo().getProductVersion());
        this.httpEvent.withInstanceName(api.getTrackingInfo().getInstanceName());
        this.httpEvent.withApiId(api.getTrackingInfo().getLegacyApiIdentifier());
        this.httpEvent.withOrgId(api.getTrackingInfo().getOrganizationId());
        return this;
    }

    @Override
    public AnalyticsHttpEventBuilder withRequest(OptionalLong payloadLength, TypedValue<Object> requestAttributes) {
        this.httpRequestAttributesFactory.from(requestAttributes).ifPresent(httpRequestAttributes -> {
            this.httpEvent.withUserAgent((String)httpRequestAttributes.getHeaders().get((Object)USER_AGENT_LOWER));
            this.httpEvent.withRequestBytes(this.payloadBytes(payloadLength, httpRequestAttributes.getHeaders()));
            this.httpEvent.withPath(httpRequestAttributes.getRequestUri());
            this.httpEvent.withVerb(httpRequestAttributes.getMethod());
            this.httpEvent.withClientIp(this.clientIpExtractor.extractClientIp((HttpRequestAttributes)httpRequestAttributes));
            this.isEdgeRequest = new LazyValue(() -> this.edgeRequestDetector.isEdgeRequest(httpRequestAttributes.getHeaders().getAll((Object)VIA_HEADER)));
        });
        return this;
    }

    @Override
    public AnalyticsHttpEventBuilder withId(String id) {
        this.httpEvent.withEventId(id);
        return this;
    }

    @Override
    public AnalyticsHttpEventBuilder withMuleAppName(String muleAppName) {
        this.httpEvent.withMuleAppName(muleAppName);
        return this;
    }

    @Override
    public AnalyticsHttpEventBuilder withFlowName(String flowName) {
        this.httpEvent.withFlowName(flowName);
        return this;
    }

    @Override
    public AnalyticsHttpEventBuilder withReceivedTimestamp(long timestamp) {
        this.httpEvent.withReceivedTs(DATE_TIME_FORMATTER.print(timestamp));
        return this;
    }

    @Override
    public AnalyticsHttpEventBuilder withRepliedTimestamp(long timestamp) {
        this.httpEvent.withRepliedTs(DATE_TIME_FORMATTER.print(timestamp));
        return this;
    }

    @Override
    public AnalyticsHttpEventBuilder withPolicyViolation(PolicyViolation policyViolation) {
        this.httpEvent.withPolicyViolation(policyViolation);
        this.httpEvent.withRequestDisposition(RequestDisposition.BLOCKED);
        return this;
    }

    @Override
    public AnalyticsHttpEventBuilder withResponse(OptionalLong payloadLength, TypedValue<Object> attributes, IntegerAction action) {
        Optional<HttpResponseAttributes> responseAttributes = this.httpResponseAttributesFactory.from(attributes);
        if (responseAttributes.isPresent()) {
            HttpResponseAttributes httpResponseAttributes = responseAttributes.get();
            this.httpEvent.withStatusCode(httpResponseAttributes.getStatusCode());
            this.httpEvent.withResponseBytes(this.payloadBytes(payloadLength, httpResponseAttributes.getHeaders()));
        } else if (new IntegerAction(805).equals((Object)action)) {
            this.httpEvent.withStatusCode(HttpConstants.HttpStatus.OK.getStatusCode());
        } else if (new IntegerAction(806).equals((Object)action)) {
            this.httpEvent.withStatusCode(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        return this;
    }

    @Override
    public AnalyticsHttpEventBuilder withClient(Client client) {
        this.httpEvent.withClientId(client.id());
        this.httpEvent.withApplicationName(client.name());
        return this;
    }

    @Override
    public boolean isEdgeRequest() {
        return (Boolean)this.isEdgeRequest.get();
    }

    @Override
    public String getApiDescription() {
        return this.apiDescription;
    }

    private int payloadBytes(OptionalLong payloadLength, MultiMap<String, String> headers) {
        try {
            if (payloadLength.isPresent()) {
                return Math.toIntExact(payloadLength.getAsLong());
            }
            if (headers.containsKey((Object)CONTENT_LENGTH_LOWER)) {
                return Integer.parseInt((String)headers.get((Object)CONTENT_LENGTH_LOWER));
            }
        }
        catch (ArithmeticException | NumberFormatException e) {
            LOGGER.debug("Unexpected error when trying to calculate payload size: {}", (Object)e.getMessage());
        }
        return -1;
    }
}

