/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import com.mulesoft.service.http.impl.netty.ForwardingToWsListenerHandler;
import com.mulesoft.service.http.impl.netty.MuleWebSocketServerProtocolHandler;
import com.mulesoft.service.http.impl.netty.NettyWebSocketRequest;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.netty.impl.message.NettyHttpRequestAdapter;
import org.mule.service.http.netty.impl.server.NettyHttp1RequestReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttpRequestContext;
import org.mule.service.http.netty.impl.server.util.ServiceTemporarilyUnavailableListenerRequestHandler;

public class WebSocketServerPipelineUpgrader
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "WebSocket Server Pipeline Upgrader";
    public final RequestMatcherRegistry<WebSocketHandler> webSocketsHandlersRegistry;

    public WebSocketServerPipelineUpgrader(RequestMatcherRegistry<WebSocketHandler> webSocketsHandlersRegistry) {
        this.webSocketsHandlersRegistry = webSocketsHandlersRegistry;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof HttpRequest)) {
            ctx.fireChannelRead(msg);
            return;
        }
        HttpRequest httpRequest = (HttpRequest)msg;
        if (!this.isWebSocketUpgradeRequest(httpRequest)) {
            ctx.fireChannelRead(msg);
            return;
        }
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().localAddress();
        NettyHttpRequestAdapter muleRequest = new NettyHttpRequestAdapter(httpRequest, socketAddress, null);
        WebSocketHandler webSocketHandler = (WebSocketHandler)this.webSocketsHandlersRegistry.find((org.mule.runtime.http.api.domain.message.request.HttpRequest)muleRequest);
        if (webSocketHandler == null) {
            ServiceTemporarilyUnavailableListenerRequestHandler error503Handler = ServiceTemporarilyUnavailableListenerRequestHandler.getInstance();
            NettyHttpRequestContext requestContext = new NettyHttpRequestContext((org.mule.runtime.http.api.domain.message.request.HttpRequest)muleRequest, ctx, this.getSslHandler(ctx));
            NettyHttp1RequestReadyCallback readyCallback = new NettyHttp1RequestReadyCallback(ctx, (org.mule.runtime.http.api.domain.message.request.HttpRequest)muleRequest);
            error503Handler.handleRequest((HttpRequestContext)requestContext, (HttpResponseReadyCallback)readyCallback);
            return;
        }
        ctx.pipeline().replace("Forward to HTTP Listener", "WebSocket Server Handler", (ChannelHandler)new MuleWebSocketServerProtocolHandler(MuleWebSocketServerProtocolHandler.defaultConfig()));
        long idleTimeout = webSocketHandler.getIdleSocketTimeoutMills();
        if (idleTimeout != -1L) {
            ctx.pipeline().addLast("wsIdleStateHandler", (ChannelHandler)new IdleStateHandler(idleTimeout, idleTimeout, idleTimeout, TimeUnit.MILLISECONDS));
        }
        ctx.pipeline().addLast("WS Aggregator", (ChannelHandler)new WebSocketFrameAggregator(65536));
        NettyWebSocketRequest upgradeRequest = new NettyWebSocketRequest(httpRequest, socketAddress, ctx);
        ctx.pipeline().addLast("Forward to WS Listener", (ChannelHandler)new ForwardingToWsListenerHandler(webSocketHandler, upgradeRequest, ctx));
        ctx.fireChannelRead(msg);
    }

    private SslHandler getSslHandler(ChannelHandlerContext ctx) {
        return (SslHandler)ctx.pipeline().get(SslHandler.class);
    }

    private boolean isWebSocketUpgradeRequest(HttpRequest request) {
        if (!request.headers().containsValue((CharSequence)"Connection", (CharSequence)"Upgrade", true)) {
            return false;
        }
        return request.headers().containsValue((CharSequence)"Upgrade", (CharSequence)"WebSocket", true);
    }
}

